/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.beam.transforms.window;

public enum WindowTriggerType {
    None("No triggering"),
    RepeatedlyForeverAfterWatermarkPastEndOfWindow("Repeatedly forever: after watermark, past the end of the window");

    private String description;

    private WindowTriggerType(String description) {
        this.description = description;
    }

    public static final String[] getDescriptions() {
        String[] descriptions = new String[WindowTriggerType.values().length];
        for (int i = 0; i < descriptions.length; ++i) {
            descriptions[i] = WindowTriggerType.values()[i].description;
        }
        return descriptions;
    }

    public static final WindowTriggerType findDescription(String description) {
        for (WindowTriggerType type : WindowTriggerType.values()) {
            if (!type.description.equalsIgnoreCase(description)) continue;
            return type;
        }
        return None;
    }

    public String getDescription() {
        return this.description;
    }
}

