/*
 * Decompiled with CFR 0.152.
 */
package org.python.indexer.ast;

import org.python.indexer.Indexer;
import org.python.indexer.Scope;
import org.python.indexer.ast.NNode;
import org.python.indexer.ast.NNodeVisitor;
import org.python.indexer.types.NType;
import org.python.indexer.types.NUnionType;
import org.python.indexer.types.NUnknownType;

public class NBinOp
extends NNode {
    static final long serialVersionUID = -8961832251782335108L;
    public NNode left;
    public NNode right;
    public String op;

    public NBinOp(NNode target, NNode value, String op) {
        this(target, value, op, 0, 1);
    }

    public NBinOp(NNode target, NNode value, String op, int start, int end) {
        super(start, end);
        this.left = target;
        this.right = value;
        this.op = op;
        this.addChildren(target, value);
    }

    @Override
    public NType resolve(Scope s) throws Exception {
        NType ltype = null;
        NType rtype = null;
        if (this.left != null) {
            ltype = NBinOp.resolveExpr(this.left, s).follow();
        }
        if (this.right != null) {
            rtype = NBinOp.resolveExpr(this.right, s).follow();
        }
        if (ltype == Indexer.idx.builtins.BaseStr || rtype == Indexer.idx.builtins.BaseStr) {
            return this.setType(Indexer.idx.builtins.BaseStr);
        }
        if (ltype == Indexer.idx.builtins.BaseNum || rtype == Indexer.idx.builtins.BaseNum) {
            return this.setType(Indexer.idx.builtins.BaseNum);
        }
        if (ltype == null) {
            return this.setType(rtype == null ? new NUnknownType() : rtype);
        }
        if (rtype == null) {
            return this.setType(new NUnknownType());
        }
        return this.setType(NUnionType.union(ltype, rtype));
    }

    public String toString() {
        return "<BinOp:" + this.left + " " + this.op + " " + this.right + ">";
    }

    @Override
    public void visit(NNodeVisitor v) {
        if (v.visit(this)) {
            this.visitNode(this.left, v);
            this.visitNode(this.right, v);
        }
    }
}

