/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.webmonitor.threadinfo;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.apache.flink.runtime.messages.ThreadInfoSample;
import org.apache.flink.runtime.webmonitor.stats.Statistics;
import org.apache.flink.shaded.guava30.com.google.common.collect.ImmutableSet;
import org.apache.flink.util.Preconditions;

public class JobVertexThreadInfoStats
implements Statistics {
    private final int requestId;
    private final long startTime;
    private final long endTime;
    private final Map<ImmutableSet<ExecutionAttemptID>, Collection<ThreadInfoSample>> samplesBySubtask;

    public JobVertexThreadInfoStats(int requestId, long startTime, long endTime, Map<ImmutableSet<ExecutionAttemptID>, Collection<ThreadInfoSample>> samplesBySubtask) {
        Preconditions.checkArgument((requestId >= 0 ? 1 : 0) != 0, (Object)"Negative request ID");
        Preconditions.checkArgument((startTime >= 0L ? 1 : 0) != 0, (Object)"Negative start time");
        Preconditions.checkArgument((endTime >= startTime ? 1 : 0) != 0, (Object)"End time before start time");
        this.requestId = requestId;
        this.startTime = startTime;
        this.endTime = endTime;
        this.samplesBySubtask = Collections.unmodifiableMap(samplesBySubtask);
    }

    public int getRequestId() {
        return this.requestId;
    }

    public long getStartTime() {
        return this.startTime;
    }

    @Override
    public long getEndTime() {
        return this.endTime;
    }

    public Map<ImmutableSet<ExecutionAttemptID>, Collection<ThreadInfoSample>> getSamplesBySubtask() {
        return this.samplesBySubtask;
    }

    public int getNumberOfSubtasks() {
        return this.samplesBySubtask.keySet().size();
    }

    public String toString() {
        return "VertexThreadInfoStats{sampleId=" + this.requestId + ", startTime=" + this.startTime + ", endTime=" + this.endTime + '}';
    }
}

