/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler.adaptive;

import java.time.Duration;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledFuture;
import javax.annotation.Nullable;
import org.apache.flink.api.common.JobStatus;
import org.apache.flink.runtime.checkpoint.CheckpointScheduling;
import org.apache.flink.runtime.executiongraph.ArchivedExecutionGraph;
import org.apache.flink.runtime.executiongraph.ExecutionGraph;
import org.apache.flink.runtime.scheduler.ExecutionGraphHandler;
import org.apache.flink.runtime.scheduler.OperatorCoordinatorHandler;
import org.apache.flink.runtime.scheduler.adaptive.FailureResult;
import org.apache.flink.runtime.scheduler.adaptive.FailureResultUtil;
import org.apache.flink.runtime.scheduler.adaptive.State;
import org.apache.flink.runtime.scheduler.adaptive.StateFactory;
import org.apache.flink.runtime.scheduler.adaptive.StateTransitions;
import org.apache.flink.runtime.scheduler.adaptive.StateWithExecutionGraph;
import org.apache.flink.runtime.scheduler.exceptionhistory.ExceptionHistoryEntry;
import org.apache.flink.runtime.scheduler.stopwithsavepoint.StopWithSavepointStoppingException;
import org.apache.flink.util.FlinkException;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.concurrent.FutureUtils;
import org.slf4j.Logger;

class StopWithSavepoint
extends StateWithExecutionGraph {
    private final Context context;
    private final CompletableFuture<String> operationFuture;
    private final CheckpointScheduling checkpointScheduling;
    @Nullable
    private Throwable operationFailureCause;
    private boolean hasPendingStateTransition = false;
    private final CompletableFuture<String> internalSavepointFuture = new CompletableFuture();

    StopWithSavepoint(Context context, ExecutionGraph executionGraph, ExecutionGraphHandler executionGraphHandler, OperatorCoordinatorHandler operatorCoordinatorHandler, CheckpointScheduling checkpointScheduling, Logger logger, ClassLoader userCodeClassLoader, CompletableFuture<String> savepointFuture, List<ExceptionHistoryEntry> failureCollection) {
        super(context, executionGraph, executionGraphHandler, operatorCoordinatorHandler, logger, userCodeClassLoader, failureCollection);
        this.context = context;
        this.checkpointScheduling = checkpointScheduling;
        this.operationFuture = new CompletableFuture();
        FutureUtils.assertNoException((CompletableFuture)this.internalSavepointFuture.exceptionally(cause -> {
            this.onSavepointFailure((Throwable)cause);
            return null;
        }));
        savepointFuture.handle((savepoint, error) -> {
            context.runIfState(this, () -> {
                if (error != null) {
                    this.internalSavepointFuture.completeExceptionally((Throwable)error);
                } else {
                    this.internalSavepointFuture.complete((String)savepoint);
                }
            }, Duration.ZERO);
            return null;
        });
    }

    @Override
    public void onLeave(Class<? extends State> newState) {
        this.operationFuture.completeExceptionally(new FlinkException("Stop with savepoint operation could not be completed.", this.operationFailureCause));
        super.onLeave(newState);
    }

    @Override
    public void cancel() {
        this.operationFailureCause = new FlinkException("The job was cancelled.");
        this.context.goToCanceling(this.getExecutionGraph(), this.getExecutionGraphHandler(), this.getOperatorCoordinatorHandler(), this.getFailures());
    }

    @Override
    public JobStatus getJobStatus() {
        return JobStatus.RUNNING;
    }

    private void onSavepointFailure(Throwable cause) {
        this.checkpointScheduling.startCheckpointScheduler();
        if (!this.hasPendingStateTransition) {
            this.operationFailureCause = cause;
            this.context.goToExecuting(this.getExecutionGraph(), this.getExecutionGraphHandler(), this.getOperatorCoordinatorHandler(), this.getFailures());
        }
    }

    @Override
    void onFailure(Throwable cause) {
        if (this.hasPendingStateTransition) {
            return;
        }
        this.hasPendingStateTransition = true;
        FutureUtils.assertNoException((CompletableFuture)this.internalSavepointFuture.handle((savepoint, savepointError) -> {
            Object ex;
            this.operationFailureCause = ex = savepointError != null ? cause : new StopWithSavepointStoppingException((String)savepoint, this.getJobId(), cause);
            FailureResultUtil.restartOrFail(this.context.howToHandleFailure((Throwable)ex), this.context, this);
            return null;
        }));
    }

    @Override
    void onGloballyTerminalState(JobStatus globallyTerminalState) {
        if (globallyTerminalState == JobStatus.FINISHED) {
            this.hasPendingStateTransition = true;
            FutureUtils.assertNoException((CompletableFuture)this.internalSavepointFuture.handle((savepoint, error) -> {
                Preconditions.checkState((error == null ? 1 : 0) != 0, (Object)"A savepoint should never fail after a job has been terminated via stop-with-savepoint.");
                this.completeOperationAndGoToFinished((String)savepoint);
                return null;
            }));
        } else {
            this.handleGlobalFailure(new FlinkException("Job did not reach the FINISHED state while performing stop-with-savepoint."));
        }
    }

    private void completeOperationAndGoToFinished(String savepoint) {
        this.operationFuture.complete(savepoint);
        this.context.goToFinished(ArchivedExecutionGraph.createFrom(this.getExecutionGraph()));
    }

    CompletableFuture<String> getOperationFuture() {
        return this.operationFuture;
    }

    static class Factory
    implements StateFactory<StopWithSavepoint> {
        private final Context context;
        private final ExecutionGraph executionGraph;
        private final ExecutionGraphHandler executionGraphHandler;
        private final OperatorCoordinatorHandler operatorCoordinatorHandler;
        private final CheckpointScheduling checkpointScheduling;
        private final Logger logger;
        private final ClassLoader userCodeClassLoader;
        private final CompletableFuture<String> savepointFuture;
        private final List<ExceptionHistoryEntry> failureCollection;

        Factory(Context context, ExecutionGraph executionGraph, ExecutionGraphHandler executionGraphHandler, OperatorCoordinatorHandler operatorCoordinatorHandler, CheckpointScheduling checkpointScheduling, Logger logger, ClassLoader userCodeClassLoader, CompletableFuture<String> savepointFuture, List<ExceptionHistoryEntry> failureCollection) {
            this.context = context;
            this.executionGraph = executionGraph;
            this.executionGraphHandler = executionGraphHandler;
            this.operatorCoordinatorHandler = operatorCoordinatorHandler;
            this.checkpointScheduling = checkpointScheduling;
            this.logger = logger;
            this.userCodeClassLoader = userCodeClassLoader;
            this.savepointFuture = savepointFuture;
            this.failureCollection = failureCollection;
        }

        @Override
        public Class<StopWithSavepoint> getStateClass() {
            return StopWithSavepoint.class;
        }

        @Override
        public StopWithSavepoint getState() {
            return new StopWithSavepoint(this.context, this.executionGraph, this.executionGraphHandler, this.operatorCoordinatorHandler, this.checkpointScheduling, this.logger, this.userCodeClassLoader, this.savepointFuture, this.failureCollection);
        }
    }

    static interface Context
    extends StateWithExecutionGraph.Context,
    StateTransitions.ToCancelling,
    StateTransitions.ToExecuting,
    StateTransitions.ToFailing,
    StateTransitions.ToRestarting {
        public FailureResult howToHandleFailure(Throwable var1);

        public ScheduledFuture<?> runIfState(State var1, Runnable var2, Duration var3);
    }
}

