/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.executiongraph;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.core.io.InputSplit;
import org.apache.flink.runtime.execution.ExecutionState;
import org.apache.flink.runtime.executiongraph.ArchivedExecutionVertex;
import org.apache.flink.runtime.executiongraph.Execution;
import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.apache.flink.runtime.executiongraph.ExecutionJobVertex;
import org.apache.flink.runtime.executiongraph.ExecutionVertex;
import org.apache.flink.runtime.executiongraph.IntermediateResult;
import org.apache.flink.runtime.executiongraph.PartitionInfo;
import org.apache.flink.runtime.jobmaster.LogicalSlot;
import org.apache.flink.runtime.taskmanager.TaskManagerLocation;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.concurrent.FutureUtils;

public class SpeculativeExecutionVertex
extends ExecutionVertex {
    private final Map<Integer, Execution> currentExecutions = new LinkedHashMap<Integer, Execution>();
    private int originalAttemptNumber;
    final Map<Integer, Integer> nextInputSplitIndexToConsumeByAttempts;

    public SpeculativeExecutionVertex(ExecutionJobVertex jobVertex, int subTaskIndex, IntermediateResult[] producedDataSets, Time timeout, long createTimestamp, int executionHistorySizeLimit, int initialAttemptCount) {
        super(jobVertex, subTaskIndex, producedDataSets, timeout, createTimestamp, executionHistorySizeLimit, initialAttemptCount);
        this.currentExecutions.put(this.currentExecution.getAttemptNumber(), this.currentExecution);
        this.originalAttemptNumber = this.currentExecution.getAttemptNumber();
        this.nextInputSplitIndexToConsumeByAttempts = new HashMap<Integer, Integer>();
    }

    public boolean containsSources() {
        return this.getJobVertex().getJobVertex().containsSources();
    }

    public boolean containsSinks() {
        return this.getJobVertex().getJobVertex().containsSinks();
    }

    public Execution createNewSpeculativeExecution(long timestamp) {
        Execution newExecution = this.createNewExecution(timestamp);
        this.getExecutionGraphAccessor().registerExecution(newExecution);
        this.currentExecutions.put(newExecution.getAttemptNumber(), newExecution);
        return newExecution;
    }

    public boolean isOriginalAttempt(int attemptNumber) {
        return attemptNumber == this.originalAttemptNumber;
    }

    @Override
    public Collection<Execution> getCurrentExecutions() {
        return Collections.unmodifiableCollection(this.currentExecutions.values());
    }

    @Override
    public Execution getCurrentExecution(int attemptNumber) {
        return (Execution)Preconditions.checkNotNull((Object)this.currentExecutions.get(attemptNumber));
    }

    @Override
    public Execution getPartitionProducer() {
        Execution finishedExecution = this.getCurrentExecutionAttempt();
        Preconditions.checkState((finishedExecution.getState() == ExecutionState.FINISHED ? 1 : 0) != 0, (Object)"It's not allowed to get the partition producer of an un-finished SpeculativeExecutionVertex");
        return finishedExecution;
    }

    @Override
    public CompletableFuture<?> cancel() {
        ArrayList cancelResultFutures = new ArrayList(this.currentExecutions.size());
        for (Execution execution : this.currentExecutions.values()) {
            execution.cancel();
            cancelResultFutures.add(execution.getReleaseFuture());
        }
        return FutureUtils.combineAll(cancelResultFutures);
    }

    @Override
    public CompletableFuture<?> suspend() {
        return FutureUtils.combineAll((Collection)this.currentExecutions.values().stream().map(Execution::suspend).collect(Collectors.toList()));
    }

    @Override
    public void fail(Throwable t) {
        this.currentExecutions.values().forEach(e -> e.fail(t));
    }

    @Override
    public void markFailed(Throwable t) {
        this.currentExecutions.values().forEach(e -> e.markFailed(t));
    }

    @Override
    CompletableFuture<?> getTerminationFuture() {
        List terminationFutures = this.currentExecutions.values().stream().map(Execution::getTerminalStateFuture).collect(Collectors.toList());
        return FutureUtils.waitForAll(terminationFutures);
    }

    @Override
    public void resetForNewExecution() {
        super.resetForNewExecution();
        this.currentExecutions.clear();
        this.currentExecutions.put(this.currentExecution.getAttemptNumber(), this.currentExecution);
        this.originalAttemptNumber = this.currentExecution.getAttemptNumber();
        this.nextInputSplitIndexToConsumeByAttempts.clear();
    }

    @Override
    void resetExecutionsInternal() {
        for (Execution execution : this.currentExecutions.values()) {
            this.resetExecution(execution);
        }
    }

    public void archiveFailedExecution(ExecutionAttemptID executionAttemptId) {
        if (this.currentExecutions.size() <= 1) {
            return;
        }
        Execution removedExecution = this.currentExecutions.remove(executionAttemptId.getAttemptNumber());
        this.nextInputSplitIndexToConsumeByAttempts.remove(executionAttemptId.getAttemptNumber());
        Preconditions.checkNotNull((Object)removedExecution, (String)"Cannot remove execution %s which does not exist.", (Object[])new Object[]{executionAttemptId});
        Preconditions.checkState((removedExecution.getState() == ExecutionState.FAILED ? 1 : 0) != 0, (String)"Cannot remove execution %s which is not FAILED.", (Object[])new Object[]{executionAttemptId});
        this.executionHistory.add(removedExecution.archive());
        if (removedExecution == this.currentExecution) {
            this.currentExecution = this.currentExecutions.values().iterator().next();
        }
    }

    @Override
    public Execution getCurrentExecutionAttempt() {
        Execution currentExecution = this.currentExecution;
        for (Execution execution : this.currentExecutions.values()) {
            if (this.getStatePriority(execution.getState()) >= this.getStatePriority(currentExecution.getState())) continue;
            currentExecution = execution;
        }
        return currentExecution;
    }

    private int getStatePriority(ExecutionState state) {
        switch (state) {
            case FINISHED: {
                return 0;
            }
            case RUNNING: {
                return 1;
            }
            case INITIALIZING: {
                return 2;
            }
            case DEPLOYING: {
                return 3;
            }
            case SCHEDULED: {
                return 4;
            }
            case CREATED: {
                return 5;
            }
            case CANCELING: {
                return 6;
            }
            case FAILED: {
                return 7;
            }
            case CANCELED: {
                return 8;
            }
        }
        throw new IllegalStateException("Execution state " + (Object)((Object)state) + " is not supported.");
    }

    @Override
    public Optional<InputSplit> getNextInputSplit(String host, int attemptNumber) {
        int index = this.nextInputSplitIndexToConsumeByAttempts.getOrDefault(attemptNumber, 0);
        Preconditions.checkState((index <= this.inputSplits.size() ? 1 : 0) != 0);
        if (index < this.inputSplits.size()) {
            this.nextInputSplitIndexToConsumeByAttempts.put(attemptNumber, index + 1);
            return Optional.of(this.inputSplits.get(index));
        }
        Optional<InputSplit> split = super.getNextInputSplit(host, attemptNumber);
        if (split.isPresent()) {
            this.nextInputSplitIndexToConsumeByAttempts.put(attemptNumber, index + 1);
        }
        return split;
    }

    @Override
    void notifyPendingDeployment(Execution execution) {
        this.getExecutionGraphAccessor().getExecutionDeploymentListener().onStartedDeployment(execution.getAttemptId(), execution.getAssignedResourceLocation().getResourceID());
    }

    @Override
    void notifyCompletedDeployment(Execution execution) {
        this.getExecutionGraphAccessor().getExecutionDeploymentListener().onCompletedDeployment(execution.getAttemptId());
    }

    @Override
    void notifyStateTransition(Execution execution, ExecutionState previousState, ExecutionState newState) {
        this.getExecutionGraphAccessor().notifyExecutionChange(execution, previousState, newState);
    }

    @Override
    public ArchivedExecutionVertex archive() {
        return new ArchivedExecutionVertex(this);
    }

    @Override
    void cachePartitionInfo(PartitionInfo partitionInfo) {
        throw new UnsupportedOperationException("Method is not supported in SpeculativeExecutionVertex.");
    }

    @Override
    public void tryAssignResource(LogicalSlot slot) {
        throw new UnsupportedOperationException("Method is not supported in SpeculativeExecutionVertex.");
    }

    @Override
    public void deploy() {
        throw new UnsupportedOperationException("Method is not supported in SpeculativeExecutionVertex.");
    }

    @Override
    public void deployToSlot(LogicalSlot slot) {
        throw new UnsupportedOperationException("Method is not supported in SpeculativeExecutionVertex.");
    }

    @Override
    public Optional<TaskManagerLocation> getPreferredLocationBasedOnState() {
        throw new UnsupportedOperationException("Method is not supported in SpeculativeExecutionVertex.");
    }

    @Override
    public CompletableFuture<TaskManagerLocation> getCurrentTaskManagerLocationFuture() {
        throw new UnsupportedOperationException("Method is not supported in SpeculativeExecutionVertex.");
    }
}

