/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.util.commtrace;

import com.ibm.as400.util.commtrace.BitBuf;
import com.ibm.as400.util.commtrace.Field;
import com.ibm.as400.util.commtrace.Flag;
import com.ibm.as400.util.commtrace.FormatProperties;
import com.ibm.as400.util.commtrace.Formatter;
import com.ibm.as400.util.commtrace.Header;
import com.ibm.as400.util.commtrace.IP6Address;
import com.ibm.as400.util.commtrace.Message;
import com.ibm.as400.util.commtrace.NDOption;

public class NeighborAdvertisement
extends Message {
    private Field router;
    private Field solicited;
    private Field override;
    private Field target;

    @Override
    public Header getNextHeader() {
        return NDOption.createNDOption(this.rawpayload);
    }

    @Override
    public int getHeaderLen() {
        return 160;
    }

    NeighborAdvertisement(BitBuf data) {
        super(data);
        this.router = new Flag(this.rawheader.slice(0, 1), "Yes", "No");
        this.solicited = new Flag(this.rawheader.slice(1, 1), "Yes", "No");
        this.override = new Flag(this.rawheader.slice(2, 1), "Yes", "No");
        this.target = new IP6Address(this.rawheader.slice(32, 128));
        this.type = 136;
    }

    @Override
    public String toString(FormatProperties filter) {
        Object[] args = new Object[]{this.router, this.solicited, this.override, this.target};
        return Formatter.jsprintf("Flags:  Router: {0,3,R}     Solicited: {1,3,R}     Override: {2,3,R}\n\t\tTarget:  {3}\n", args) + this.printHexHeader() + this.printnext(filter);
    }

    public String getRouter() {
        return this.router.toString();
    }

    public String getSolicited() {
        return this.solicited.toString();
    }

    public String getOverride() {
        return this.override.toString();
    }

    public String getTarget() {
        return this.target.toString();
    }
}

