/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.QSYSObjectPathName;
import com.ibm.as400.access.Trace;

public class PanelGroupHelpIdentifier {
    public static final int STATUS_NAME_NOT_CORRECT = 0;
    public static final int STATUS_FOUND = 1;
    public static final int STATUS_OBJECT_ACCESS_FAILURE = 2;
    public static final int STATUS_UNKNOWN = -1;
    private String helpID_;
    private String path_;
    private String found_;
    private String anchor_;

    PanelGroupHelpIdentifier(String helpID, String object, String library, String type, String found, String anchor) {
        this.helpID_ = helpID;
        if (!type.equalsIgnoreCase("PNLGRP")) {
            if (Trace.isTraceOn()) {
                Trace.log(2, "Panel group help identifier constructed with wrong object type: '" + type + "'");
            }
            throw new ExtendedIllegalArgumentException("type(" + type + ")", 2);
        }
        if (object.length() == 0 || library.length() == 0) {
            this.path_ = "";
            if (Trace.isTraceOn()) {
                Trace.log(4, "Panel group help identifier not fully specified: object = '" + object + "' and library = '" + library + "'");
            }
        } else {
            this.path_ = QSYSObjectPathName.toPath(library, object, type);
        }
        this.found_ = found;
        this.anchor_ = anchor;
    }

    public String getName() {
        return this.helpID_;
    }

    public String getPath() {
        return this.path_;
    }

    public int getStatus() {
        if (this.found_.equals("0")) {
            return 0;
        }
        if (this.found_.equals("1")) {
            return 1;
        }
        if (this.found_.equals("2")) {
            return 2;
        }
        return -1;
    }

    public String getAnchor() {
        return this.anchor_;
    }

    public String toString() {
        return super.toString() + "[" + this.getStatus() + "," + this.getName() + "]";
    }
}

