/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400BidiTransform;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.EnvironmentVariable;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.InternalErrorException;
import com.ibm.as400.access.ObjectDoesNotExistException;
import com.ibm.as400.access.ProgramParameter;
import com.ibm.as400.access.ServiceProgramCall;
import com.ibm.as400.access.Trace;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;

public class EnvironmentVariableList
implements Serializable {
    static final long serialVersionUID = 4L;
    private AS400 system_ = null;
    private transient ServiceProgramCall spc_ = null;
    private transient PropertyChangeSupport propertyChangeListeners_ = null;

    public EnvironmentVariableList() {
        if (Trace.traceOn_) {
            Trace.log(1, "Constructing EnvironmentVariableList object.");
        }
    }

    public EnvironmentVariableList(AS400 system) {
        this();
        if (Trace.traceOn_) {
            Trace.log(1, " system: " + system);
        }
        if (system == null) {
            Trace.log(2, "Parameter 'system' is null.");
            throw new NullPointerException("system");
        }
        this.system_ = system;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (Trace.traceOn_) {
            Trace.log(1, "Adding property change listener.");
        }
        if (listener == null) {
            Trace.log(2, "Parameter 'listener' is null.");
            throw new NullPointerException("listener");
        }
        EnvironmentVariableList environmentVariableList = this;
        synchronized (environmentVariableList) {
            if (this.propertyChangeListeners_ == null) {
                this.propertyChangeListeners_ = new PropertyChangeSupport(this);
            }
            this.propertyChangeListeners_.addPropertyChangeListener(listener);
        }
    }

    public Enumeration<EnvironmentVariable> getEnvironmentVariables() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        return Collections.enumeration(this.getEnvironmentVariablesList());
    }

    public List<EnvironmentVariable> getEnvironmentVariablesList() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting environment variables.");
        }
        if (this.spc_ == null) {
            this.spc_ = EnvironmentVariable.setupServiceProgramCall(this.system_);
        }
        ProgramParameter[] parameters = new ProgramParameter[]{new ProgramParameter(2, 4096), new ProgramParameter(2, new byte[]{0, 0, 16, 0}, 4), new ProgramParameter(2, 1024), new ProgramParameter(2, new byte[]{0, 0, 4, 0}, 4), EnvironmentVariable.nullParameter};
        int rv = EnvironmentVariable.runServiceProgram(this.spc_, "Qp0zGetAllSysEnv", parameters, 3404, 3025);
        int actualListBufferSize = BinaryConverter.byteArrayToInt(parameters[1].getOutputData(), 0);
        int actualCcsidBufferSize = BinaryConverter.byteArrayToInt(parameters[3].getOutputData(), 0);
        if (rv == 3404) {
            if (Trace.traceOn_) {
                Trace.log(3, "ENOSPC returned, getting environment variable list again with " + actualListBufferSize + " bytes for the list and " + actualCcsidBufferSize + " bytes for the ccsids.");
            }
            try {
                parameters[0].setOutputDataLength(actualListBufferSize);
                parameters[1].setInputData(BinaryConverter.intToByteArray(actualListBufferSize));
                parameters[2].setOutputDataLength(actualCcsidBufferSize);
                parameters[3].setInputData(BinaryConverter.intToByteArray(actualCcsidBufferSize));
            }
            catch (PropertyVetoException e) {
                Trace.log(2, "Unexpected PropertyVetoException:", (Throwable)e);
                throw new InternalErrorException(10);
            }
            EnvironmentVariable.runServiceProgram(this.spc_, "Qp0zGetAllSysEnv", parameters, 0, 0);
        } else if (rv == 3025) {
            return new LinkedList<EnvironmentVariable>();
        }
        LinkedList<EnvironmentVariable> list = new LinkedList<EnvironmentVariable>();
        int offsetIntoListBuffer = 0;
        int offsetIntoCcsidBuffer = 0;
        byte[] listBufferBytes = parameters[0].getOutputData();
        byte[] ccsidBufferBytes = parameters[2].getOutputData();
        do {
            int equalPosition = offsetIntoListBuffer;
            while (listBufferBytes[equalPosition] != 126) {
                ++equalPosition;
            }
            int nullPosition = equalPosition;
            while (listBufferBytes[nullPosition] != 0) {
                ++nullPosition;
            }
            byte[] nameBytes = new byte[equalPosition - offsetIntoListBuffer + 1];
            System.arraycopy(listBufferBytes, offsetIntoListBuffer, nameBytes, 0, nameBytes.length - 1);
            byte[] valueBytes = new byte[nullPosition - equalPosition];
            System.arraycopy(listBufferBytes, equalPosition + 1, valueBytes, 0, valueBytes.length - 1);
            int ccsid = BinaryConverter.byteArrayToInt(ccsidBufferBytes, offsetIntoCcsidBuffer);
            list.add(new EnvironmentVariable(this.system_, this.spc_, nameBytes, valueBytes, ccsid));
            offsetIntoListBuffer = nullPosition + 1;
            offsetIntoCcsidBuffer += 4;
        } while (listBufferBytes[offsetIntoListBuffer] != 0);
        return list;
    }

    public Properties getProperties() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting environment variables as Properties.");
        }
        Properties properties = new Properties();
        Enumeration<EnvironmentVariable> list = this.getEnvironmentVariables();
        while (list.hasMoreElements()) {
            EnvironmentVariable environmentVariable = list.nextElement();
            properties.put(environmentVariable.getName(), environmentVariable.getValue());
        }
        return properties;
    }

    public AS400 getSystem() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting system: " + this.system_);
        }
        return this.system_;
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (Trace.traceOn_) {
            Trace.log(1, "Removing property change listener.");
        }
        if (listener == null) {
            Trace.log(2, "Parameter 'listener' is null.");
            throw new NullPointerException("listener");
        }
        if (this.propertyChangeListeners_ != null) {
            this.propertyChangeListeners_.removePropertyChangeListener(listener);
        }
    }

    public void setProperties(Properties properties) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.setProperties(properties, -1);
    }

    public void setProperties(Properties properties, int stringType) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting environment variables from Properties.");
        }
        if (properties == null) {
            Trace.log(2, "Parameter 'properties' is null.");
            throw new NullPointerException("properties");
        }
        if (this.spc_ == null) {
            this.spc_ = EnvironmentVariable.setupServiceProgramCall(this.system_);
        }
        if (stringType == -1) {
            stringType = AS400BidiTransform.getStringType(this.system_.getCcsid());
        }
        Enumeration<?> propertyNames = properties.propertyNames();
        while (propertyNames.hasMoreElements()) {
            String propertyName = (String)propertyNames.nextElement();
            EnvironmentVariable environmentVariable = new EnvironmentVariable(this.system_, this.spc_, propertyName);
            environmentVariable.setValue(properties.getProperty(propertyName), 0, stringType);
        }
    }

    public void setSystem(AS400 system) {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting system: " + system);
        }
        if (system == null) {
            Trace.log(2, "Parameter 'system' is null.");
            throw new NullPointerException("system");
        }
        if (this.spc_ != null) {
            Trace.log(2, "Cannot set property 'system' after connect.");
            throw new ExtendedIllegalStateException("system", 5);
        }
        if (this.propertyChangeListeners_ == null) {
            this.system_ = system;
        } else {
            AS400 newValue;
            AS400 oldValue = this.system_;
            this.system_ = newValue = system;
            this.propertyChangeListeners_.firePropertyChange("system", oldValue, newValue);
        }
    }
}

