/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.workflow.actions.evaluatetablecontent;

import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.Const;
import org.apache.hop.core.database.Database;
import org.apache.hop.core.database.DatabaseMeta;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.database.dialog.DatabaseExplorerDialog;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.dialog.MessageBox;
import org.apache.hop.ui.core.widget.MetaSelectionLine;
import org.apache.hop.ui.core.widget.StyledTextComp;
import org.apache.hop.ui.core.widget.TextVar;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.apache.hop.ui.workflow.action.ActionDialog;
import org.apache.hop.ui.workflow.dialog.WorkflowDialog;
import org.apache.hop.workflow.WorkflowMeta;
import org.apache.hop.workflow.action.IAction;
import org.apache.hop.workflow.actions.evaluatetablecontent.ActionEvalTableContent;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class ActionEvalTableContentDialog
extends ActionDialog {
    private static final Class<?> PKG = ActionEvalTableContent.class;
    private Button wbTable;
    private Button wbSqlTable;
    private Text wName;
    private MetaSelectionLine<DatabaseMeta> wConnection;
    private ActionEvalTableContent action;
    private boolean changed;
    private Label wlUseSubs;
    private Button wUseSubs;
    private Label wlClearResultList;
    private Button wClearResultList;
    private Label wlAddRowsToResult;
    private Button wAddRowsToResult;
    private Button wCustomSql;
    private Label wlSql;
    private StyledTextComp wSql;
    private Label wlPosition;
    private Label wlSchemaname;
    private TextVar wSchemaname;
    private Label wlTablename;
    private TextVar wTablename;
    private CCombo wSuccessCondition;
    private TextVar wLimit;

    public ActionEvalTableContentDialog(Shell parent, ActionEvalTableContent action, WorkflowMeta workflowMeta, IVariables variables) {
        super(parent, workflowMeta, variables);
        this.action = action;
        if (this.action.getName() == null) {
            this.action.setName(BaseMessages.getString(PKG, (String)"ActionEvalTableContent.Name.Default", (String[])new String[0]));
        }
    }

    public IAction open() {
        this.shell = new Shell(this.getParent(), 3312);
        PropsUi.setLook((Widget)this.shell);
        WorkflowDialog.setShellImage((Shell)this.shell, (IAction)this.action);
        ModifyListener lsMod = e -> this.action.setChanged();
        this.changed = this.action.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = PropsUi.getFormMargin();
        formLayout.marginHeight = PropsUi.getFormMargin();
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"ActionEvalTableContent.Title", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = PropsUi.getMargin();
        Button wOk = new Button((Composite)this.shell, 8);
        wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        wOk.addListener(13, e -> this.ok());
        Button wCancel = new Button((Composite)this.shell, 8);
        wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        wCancel.addListener(13, e -> this.cancel());
        BaseTransformDialog.positionBottomButtons((Composite)this.shell, (Button[])new Button[]{wOk, wCancel}, (int)margin, null);
        Label wlName = new Label((Composite)this.shell, 131072);
        wlName.setText(BaseMessages.getString(PKG, (String)"ActionEvalTableContent.Name.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlName);
        FormData fdlName = new FormData();
        fdlName.left = new FormAttachment(0, 0);
        fdlName.right = new FormAttachment(middle, -margin);
        fdlName.top = new FormAttachment(0, margin);
        wlName.setLayoutData((Object)fdlName);
        this.wName = new Text((Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wName);
        this.wName.addModifyListener(lsMod);
        FormData fdName = new FormData();
        fdName.left = new FormAttachment(middle, 0);
        fdName.top = new FormAttachment(0, margin);
        fdName.right = new FormAttachment(100, 0);
        this.wName.setLayoutData((Object)fdName);
        this.wConnection = this.addConnectionLine((Composite)this.shell, (Control)this.wName, this.action.getDatabase(), lsMod);
        this.wlSchemaname = new Label((Composite)this.shell, 131072);
        this.wlSchemaname.setText(BaseMessages.getString(PKG, (String)"ActionEvalTableContent.Schemaname.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlSchemaname);
        FormData fdlSchemaname = new FormData();
        fdlSchemaname.left = new FormAttachment(0, 0);
        fdlSchemaname.right = new FormAttachment(middle, -margin);
        fdlSchemaname.top = new FormAttachment(this.wConnection, margin);
        this.wlSchemaname.setLayoutData((Object)fdlSchemaname);
        this.wSchemaname = new TextVar(this.variables, (Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wSchemaname);
        this.wSchemaname.setToolTipText(BaseMessages.getString(PKG, (String)"ActionEvalTableContent.Schemaname.Tooltip", (String[])new String[0]));
        this.wSchemaname.addModifyListener(lsMod);
        FormData fdSchemaname = new FormData();
        fdSchemaname.left = new FormAttachment(middle, 0);
        fdSchemaname.top = new FormAttachment(this.wConnection, margin);
        fdSchemaname.right = new FormAttachment(100, 0);
        this.wSchemaname.setLayoutData((Object)fdSchemaname);
        this.wlTablename = new Label((Composite)this.shell, 131072);
        this.wlTablename.setText(BaseMessages.getString(PKG, (String)"ActionEvalTableContent.Tablename.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlTablename);
        FormData fdlTablename = new FormData();
        fdlTablename.left = new FormAttachment(0, 0);
        fdlTablename.right = new FormAttachment(middle, -margin);
        fdlTablename.top = new FormAttachment((Control)this.wSchemaname, margin);
        this.wlTablename.setLayoutData((Object)fdlTablename);
        this.wbTable = new Button((Composite)this.shell, 0x1000008);
        PropsUi.setLook((Widget)this.wbTable);
        this.wbTable.setText(BaseMessages.getString(PKG, (String)"System.Button.Browse", (String[])new String[0]));
        FormData fdbTable = new FormData();
        fdbTable.right = new FormAttachment(100, 0);
        fdbTable.top = new FormAttachment((Control)this.wSchemaname, margin / 2);
        this.wbTable.setLayoutData((Object)fdbTable);
        this.wbTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ActionEvalTableContentDialog.this.getTableName();
            }
        });
        this.wTablename = new TextVar(this.variables, (Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wTablename);
        this.wTablename.setToolTipText(BaseMessages.getString(PKG, (String)"ActionEvalTableContent.Tablename.Tooltip", (String[])new String[0]));
        this.wTablename.addModifyListener(lsMod);
        FormData fdTablename = new FormData();
        fdTablename.left = new FormAttachment(middle, 0);
        fdTablename.top = new FormAttachment((Control)this.wSchemaname, margin);
        fdTablename.right = new FormAttachment((Control)this.wbTable, -margin);
        this.wTablename.setLayoutData((Object)fdTablename);
        Group wSuccessGroup = new Group((Composite)this.shell, 32);
        PropsUi.setLook((Widget)wSuccessGroup);
        wSuccessGroup.setText(BaseMessages.getString(PKG, (String)"ActionEvalTableContent.SuccessGroup.Group.Label", (String[])new String[0]));
        FormLayout successGroupLayout = new FormLayout();
        successGroupLayout.marginWidth = 10;
        successGroupLayout.marginHeight = 10;
        wSuccessGroup.setLayout((Layout)successGroupLayout);
        Label wlSuccessCondition = new Label((Composite)wSuccessGroup, 131072);
        wlSuccessCondition.setText(BaseMessages.getString(PKG, (String)"ActionEvalTableContent.SuccessCondition.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlSuccessCondition);
        FormData fdlSuccessCondition = new FormData();
        fdlSuccessCondition.left = new FormAttachment(0, -margin);
        fdlSuccessCondition.right = new FormAttachment(middle, -2 * margin);
        fdlSuccessCondition.top = new FormAttachment(0, margin);
        wlSuccessCondition.setLayoutData((Object)fdlSuccessCondition);
        this.wSuccessCondition = new CCombo((Composite)wSuccessGroup, 2060);
        this.wSuccessCondition.setItems(ActionEvalTableContent.successConditionsDesc);
        this.wSuccessCondition.select(0);
        PropsUi.setLook((Widget)this.wSuccessCondition);
        FormData fdSuccessCondition = new FormData();
        fdSuccessCondition.left = new FormAttachment(middle, -margin);
        fdSuccessCondition.top = new FormAttachment(0, margin);
        fdSuccessCondition.right = new FormAttachment(100, 0);
        this.wSuccessCondition.setLayoutData((Object)fdSuccessCondition);
        this.wSuccessCondition.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
            }
        });
        Label wlLimit = new Label((Composite)wSuccessGroup, 131072);
        wlLimit.setText(BaseMessages.getString(PKG, (String)"ActionEvalTableContent.Limit.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlLimit);
        FormData fdlLimit = new FormData();
        fdlLimit.left = new FormAttachment(0, -margin);
        fdlLimit.top = new FormAttachment((Control)this.wSuccessCondition, margin);
        fdlLimit.right = new FormAttachment(middle, -2 * margin);
        wlLimit.setLayoutData((Object)fdlLimit);
        this.wLimit = new TextVar(this.variables, (Composite)wSuccessGroup, 18436, BaseMessages.getString(PKG, (String)"ActionEvalTableContent.Limit.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wLimit);
        this.wLimit.addModifyListener(lsMod);
        FormData fdLimit = new FormData();
        fdLimit.left = new FormAttachment(middle, -margin);
        fdLimit.top = new FormAttachment((Control)this.wSuccessCondition, margin);
        fdLimit.right = new FormAttachment(100, -margin);
        this.wLimit.setLayoutData((Object)fdLimit);
        FormData fdSuccessGroup = new FormData();
        fdSuccessGroup.left = new FormAttachment(0, margin);
        fdSuccessGroup.top = new FormAttachment((Control)this.wbTable, margin);
        fdSuccessGroup.right = new FormAttachment(100, -margin);
        wSuccessGroup.setLayoutData((Object)fdSuccessGroup);
        Group wCustomGroup = new Group((Composite)this.shell, 32);
        PropsUi.setLook((Widget)wCustomGroup);
        wCustomGroup.setText(BaseMessages.getString(PKG, (String)"ActionEvalTableContent.CustomGroup.Group.Label", (String[])new String[0]));
        FormLayout customGroupLayout = new FormLayout();
        customGroupLayout.marginWidth = 10;
        customGroupLayout.marginHeight = 10;
        wCustomGroup.setLayout((Layout)customGroupLayout);
        Label wlCustomSql = new Label((Composite)wCustomGroup, 131072);
        wlCustomSql.setText(BaseMessages.getString(PKG, (String)"ActionEvalTableContent.customSQL.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlCustomSql);
        FormData fdlCustomSql = new FormData();
        fdlCustomSql.left = new FormAttachment(0, -margin);
        fdlCustomSql.top = new FormAttachment(0, margin);
        fdlCustomSql.right = new FormAttachment(middle, -2 * margin);
        wlCustomSql.setLayoutData((Object)fdlCustomSql);
        this.wCustomSql = new Button((Composite)wCustomGroup, 32);
        PropsUi.setLook((Widget)this.wCustomSql);
        this.wCustomSql.setToolTipText(BaseMessages.getString(PKG, (String)"ActionEvalTableContent.customSQL.Tooltip", (String[])new String[0]));
        FormData fdCustomSql = new FormData();
        fdCustomSql.left = new FormAttachment(middle, -margin);
        fdCustomSql.top = new FormAttachment((Control)wlCustomSql, 0, 0x1000000);
        fdCustomSql.right = new FormAttachment(100, 0);
        this.wCustomSql.setLayoutData((Object)fdCustomSql);
        this.wCustomSql.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ActionEvalTableContentDialog.this.setCustomSql();
                ActionEvalTableContentDialog.this.action.setChanged();
            }
        });
        this.wlUseSubs = new Label((Composite)wCustomGroup, 131072);
        this.wlUseSubs.setText(BaseMessages.getString(PKG, (String)"ActionEvalTableContent.UseVariableSubst.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlUseSubs);
        FormData fdlUseSubs = new FormData();
        fdlUseSubs.left = new FormAttachment(0, -margin);
        fdlUseSubs.top = new FormAttachment((Control)wlCustomSql, 2 * margin);
        fdlUseSubs.right = new FormAttachment(middle, -2 * margin);
        this.wlUseSubs.setLayoutData((Object)fdlUseSubs);
        this.wUseSubs = new Button((Composite)wCustomGroup, 32);
        PropsUi.setLook((Widget)this.wUseSubs);
        this.wUseSubs.setToolTipText(BaseMessages.getString(PKG, (String)"ActionEvalTableContent.UseVariableSubst.Tooltip", (String[])new String[0]));
        FormData fdUseSubs = new FormData();
        fdUseSubs.left = new FormAttachment(middle, -margin);
        fdUseSubs.top = new FormAttachment((Control)this.wlUseSubs, 0, 0x1000000);
        fdUseSubs.right = new FormAttachment(100, 0);
        this.wUseSubs.setLayoutData((Object)fdUseSubs);
        this.wUseSubs.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ActionEvalTableContentDialog.this.action.setChanged();
            }
        });
        this.wlClearResultList = new Label((Composite)wCustomGroup, 131072);
        this.wlClearResultList.setText(BaseMessages.getString(PKG, (String)"ActionEvalTableContent.ClearResultList.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlClearResultList);
        FormData fdlClearResultList = new FormData();
        fdlClearResultList.left = new FormAttachment(0, -margin);
        fdlClearResultList.top = new FormAttachment((Control)this.wlUseSubs, 2 * margin);
        fdlClearResultList.right = new FormAttachment(middle, -2 * margin);
        this.wlClearResultList.setLayoutData((Object)fdlClearResultList);
        this.wClearResultList = new Button((Composite)wCustomGroup, 32);
        PropsUi.setLook((Widget)this.wClearResultList);
        this.wClearResultList.setToolTipText(BaseMessages.getString(PKG, (String)"ActionEvalTableContent.ClearResultList.Tooltip", (String[])new String[0]));
        FormData fdClearResultList = new FormData();
        fdClearResultList.left = new FormAttachment(middle, -margin);
        fdClearResultList.top = new FormAttachment((Control)this.wlClearResultList, 0, 0x1000000);
        fdClearResultList.right = new FormAttachment(100, 0);
        this.wClearResultList.setLayoutData((Object)fdClearResultList);
        this.wClearResultList.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ActionEvalTableContentDialog.this.action.setChanged();
            }
        });
        this.wlAddRowsToResult = new Label((Composite)wCustomGroup, 131072);
        this.wlAddRowsToResult.setText(BaseMessages.getString(PKG, (String)"ActionEvalTableContent.AddRowsToResult.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlAddRowsToResult);
        FormData fdlAddRowsToResult = new FormData();
        fdlAddRowsToResult.left = new FormAttachment(0, -margin);
        fdlAddRowsToResult.top = new FormAttachment((Control)this.wlClearResultList, 2 * margin);
        fdlAddRowsToResult.right = new FormAttachment(middle, -2 * margin);
        this.wlAddRowsToResult.setLayoutData((Object)fdlAddRowsToResult);
        this.wAddRowsToResult = new Button((Composite)wCustomGroup, 32);
        PropsUi.setLook((Widget)this.wAddRowsToResult);
        this.wAddRowsToResult.setToolTipText(BaseMessages.getString(PKG, (String)"ActionEvalTableContent.AddRowsToResult.Tooltip", (String[])new String[0]));
        FormData fdAddRowsToResult = new FormData();
        fdAddRowsToResult.left = new FormAttachment(middle, -margin);
        fdAddRowsToResult.top = new FormAttachment((Control)this.wlAddRowsToResult, 0, 0x1000000);
        fdAddRowsToResult.right = new FormAttachment(100, 0);
        this.wAddRowsToResult.setLayoutData((Object)fdAddRowsToResult);
        this.wAddRowsToResult.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ActionEvalTableContentDialog.this.action.setChanged();
            }
        });
        this.wlPosition = new Label((Composite)wCustomGroup, 0);
        PropsUi.setLook((Widget)this.wlPosition);
        FormData fdlPosition = new FormData();
        fdlPosition.left = new FormAttachment(0, 0);
        fdlPosition.right = new FormAttachment(100, 0);
        fdlPosition.bottom = new FormAttachment(100, -margin);
        this.wlPosition.setLayoutData((Object)fdlPosition);
        this.wlSql = new Label((Composite)wCustomGroup, 0);
        this.wlSql.setText(BaseMessages.getString(PKG, (String)"ActionEvalTableContent.Script.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlSql);
        FormData fdlSql = new FormData();
        fdlSql.left = new FormAttachment(0, 0);
        fdlSql.top = new FormAttachment((Control)this.wlAddRowsToResult, 2 * margin);
        this.wlSql.setLayoutData((Object)fdlSql);
        this.wbSqlTable = new Button((Composite)wCustomGroup, 0x1000008);
        PropsUi.setLook((Widget)this.wbSqlTable);
        this.wbSqlTable.setText(BaseMessages.getString(PKG, (String)"ActionEvalTableContent.GetSQLAndSelectStatement", (String[])new String[0]));
        FormData fdbSqlTable = new FormData();
        fdbSqlTable.right = new FormAttachment(100, 0);
        fdbSqlTable.top = new FormAttachment((Control)this.wAddRowsToResult, margin);
        this.wbSqlTable.setLayoutData((Object)fdbSqlTable);
        this.wbSqlTable.addListener(13, e -> this.getSql());
        this.wSql = new StyledTextComp((IVariables)this.action, (Composite)wCustomGroup, 19202);
        PropsUi.setLook((Widget)this.wSql, (int)1);
        this.wSql.addModifyListener(lsMod);
        FormData fdSql = new FormData();
        fdSql.left = new FormAttachment(0, 0);
        fdSql.top = new FormAttachment((Control)this.wbSqlTable, margin);
        fdSql.right = new FormAttachment(100, -10);
        fdSql.bottom = new FormAttachment((Control)this.wlPosition, -margin);
        this.wSql.setLayoutData((Object)fdSql);
        this.wSql.addModifyListener(arg0 -> this.setPosition());
        this.wSql.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                ActionEvalTableContentDialog.this.setPosition();
            }

            public void keyReleased(KeyEvent e) {
                ActionEvalTableContentDialog.this.setPosition();
            }
        });
        this.wSql.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                ActionEvalTableContentDialog.this.setPosition();
            }

            public void focusLost(FocusEvent e) {
                ActionEvalTableContentDialog.this.setPosition();
            }
        });
        this.wSql.addMouseListener(new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                ActionEvalTableContentDialog.this.setPosition();
            }

            public void mouseDown(MouseEvent e) {
                ActionEvalTableContentDialog.this.setPosition();
            }

            public void mouseUp(MouseEvent e) {
                ActionEvalTableContentDialog.this.setPosition();
            }
        });
        this.wSql.addModifyListener(lsMod);
        FormData fdCustomGroup = new FormData();
        fdCustomGroup.left = new FormAttachment(0, margin);
        fdCustomGroup.top = new FormAttachment((Control)wSuccessGroup, margin);
        fdCustomGroup.right = new FormAttachment(100, -margin);
        fdCustomGroup.bottom = new FormAttachment((Control)wOk, -margin);
        wCustomGroup.setLayoutData((Object)fdCustomGroup);
        this.getData();
        this.setCustomSql();
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.action;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void getSql() {
        DatabaseMeta inf = this.getWorkflowMeta().findDatabase(this.wConnection.getText(), this.variables);
        if (inf != null) {
            DatabaseExplorerDialog std = new DatabaseExplorerDialog(this.shell, 0, this.variables, inf, this.getWorkflowMeta().getDatabases());
            if (!std.open()) return;
            String sql = "SELECT *" + Const.CR + "FROM " + inf.getQuotedSchemaTableCombination(this.variables, std.getSchemaName(), std.getTableName()) + Const.CR;
            this.wSql.setText(sql);
            MessageBox yn = new MessageBox(this.shell, 452);
            yn.setMessage(BaseMessages.getString(PKG, (String)"ActionEvalTableContent.IncludeFieldNamesInSQL", (String[])new String[0]));
            yn.setText(BaseMessages.getString(PKG, (String)"ActionEvalTableContent.DialogCaptionQuestion", (String[])new String[0]));
            int id = yn.open();
            switch (id) {
                case 256: {
                    return;
                }
                case 128: {
                    this.wSql.setText(sql);
                    return;
                }
                case 64: {
                    try (Database db = new Database(loggingObject, this.variables, inf);){
                        db.connect();
                        IRowMeta fields = db.getQueryFields(sql, false);
                        if (fields != null) {
                            sql = "SELECT" + Const.CR;
                            for (int i = 0; i < fields.size(); ++i) {
                                IValueMeta field = fields.getValueMeta(i);
                                sql = i == 0 ? sql + "  " : sql + ", ";
                                sql = sql + inf.quoteField(field.getName()) + Const.CR;
                            }
                            sql = sql + "FROM " + inf.getQuotedSchemaTableCombination(this.variables, std.getSchemaName(), std.getTableName()) + Const.CR;
                            this.wSql.setText(sql);
                            return;
                        } else {
                            MessageBox mb = new MessageBox(this.shell, 33);
                            mb.setMessage(BaseMessages.getString(PKG, (String)"ActionEvalTableContent.ERROR_CouldNotRetrieveFields", (String[])new String[0]) + Const.CR + BaseMessages.getString(PKG, (String)"ActionEvalTableContent.PerhapsNoPermissions", (String[])new String[0]));
                            mb.setText(BaseMessages.getString(PKG, (String)"ActionEvalTableContent.DialogCaptionError2", (String[])new String[0]));
                            mb.open();
                        }
                        return;
                    }
                    catch (HopException e) {
                        MessageBox mb = new MessageBox(this.shell, 33);
                        mb.setText(BaseMessages.getString(PKG, (String)"ActionEvalTableContent.DialogCaptionError3", (String[])new String[0]));
                        mb.setMessage(BaseMessages.getString(PKG, (String)"ActionEvalTableContent.AnErrorOccurred", (String[])new String[0]) + Const.CR + e.getMessage());
                        mb.open();
                        return;
                    }
                }
            }
            return;
        }
        MessageBox mb = new MessageBox(this.shell, 33);
        mb.setMessage(BaseMessages.getString(PKG, (String)"ActionEvalTableContent.ConnectionNoLongerAvailable", (String[])new String[0]));
        mb.setText(BaseMessages.getString(PKG, (String)"ActionEvalTableContent.DialogCaptionError4", (String[])new String[0]));
        mb.open();
    }

    public void setPosition() {
        int lineNumber = this.wSql.getLineNumber();
        int columnNumber = this.wSql.getColumnNumber();
        this.wlPosition.setText(BaseMessages.getString(PKG, (String)"ActionEvalTableContent.Position.Label", (String[])new String[]{"" + lineNumber, "" + columnNumber}));
    }

    private void setCustomSql() {
        this.wlSql.setEnabled(this.wCustomSql.getSelection());
        this.wSql.setEnabled(this.wCustomSql.getSelection());
        this.wlAddRowsToResult.setEnabled(this.wCustomSql.getSelection());
        this.wAddRowsToResult.setEnabled(this.wCustomSql.getSelection());
        this.wlClearResultList.setEnabled(this.wCustomSql.getSelection());
        this.wClearResultList.setEnabled(this.wCustomSql.getSelection());
        this.wlUseSubs.setEnabled(this.wCustomSql.getSelection());
        this.wbSqlTable.setEnabled(this.wCustomSql.getSelection());
        this.wUseSubs.setEnabled(this.wCustomSql.getSelection());
        this.wbTable.setEnabled(!this.wCustomSql.getSelection());
        this.wTablename.setEnabled(!this.wCustomSql.getSelection());
        this.wlTablename.setEnabled(!this.wCustomSql.getSelection());
        this.wlSchemaname.setEnabled(!this.wCustomSql.getSelection());
        this.wSchemaname.setEnabled(!this.wCustomSql.getSelection());
    }

    public void getData() {
        if (this.action.getName() != null) {
            this.wName.setText(this.action.getName());
        }
        if (this.action.getDatabase() != null) {
            this.wConnection.setText(this.action.getDatabase().getName());
        }
        if (this.action.getSchemaname() != null) {
            this.wSchemaname.setText(this.action.getSchemaname());
        }
        if (this.action.getTablename() != null) {
            this.wTablename.setText(this.action.getTablename());
        }
        this.wSuccessCondition.setText(ActionEvalTableContent.getSuccessConditionDesc(this.action.getSuccessCondition()));
        if (this.action.getLimit() != null) {
            this.wLimit.setText(this.action.getLimit());
        } else {
            this.wLimit.setText("0");
        }
        this.wCustomSql.setSelection(this.action.isUseCustomSql());
        this.wUseSubs.setSelection(this.action.isUseVars());
        this.wClearResultList.setSelection(this.action.isClearResultList());
        this.wAddRowsToResult.setSelection(this.action.isAddRowsResult());
        if (this.action.getCustomSql() != null) {
            this.wSql.setText(this.action.getCustomSql());
        }
        this.wName.selectAll();
        this.wName.setFocus();
    }

    private void cancel() {
        this.action.setChanged(this.changed);
        this.action = null;
        this.dispose();
    }

    private void ok() {
        if (Utils.isEmpty((CharSequence)this.wName.getText())) {
            MessageBox mb = new MessageBox(this.shell, 33);
            mb.setMessage("Please give this action a name.");
            mb.setText("Enter the name of the action");
            mb.open();
            return;
        }
        this.action.setName(this.wName.getText());
        this.action.setDatabase(this.getWorkflowMeta().findDatabase(this.wConnection.getText(), this.variables));
        this.action.setSchemaname(this.wSchemaname.getText());
        this.action.setTablename(this.wTablename.getText());
        this.action.setSuccessCondition(ActionEvalTableContent.getSuccessConditionByDesc(this.wSuccessCondition.getText()));
        this.action.setLimit(this.wLimit.getText());
        this.action.setUseCustomSql(this.wCustomSql.getSelection());
        this.action.setUseVars(this.wUseSubs.getSelection());
        this.action.setAddRowsResult(this.wAddRowsToResult.getSelection());
        this.action.setClearResultList(this.wClearResultList.getSelection());
        this.action.setCustomSql(this.wSql.getText());
        this.dispose();
    }

    private void getTableName() {
        String databaseName = this.wConnection.getText();
        if (StringUtils.isNotEmpty((String)databaseName)) {
            DatabaseMeta databaseMeta = this.getWorkflowMeta().findDatabase(databaseName, this.variables);
            if (databaseMeta != null) {
                DatabaseExplorerDialog std = new DatabaseExplorerDialog(this.shell, 0, this.variables, databaseMeta, this.getWorkflowMeta().getDatabases());
                std.setSelectedSchemaAndTable(this.wSchemaname.getText(), this.wTablename.getText());
                if (std.open()) {
                    this.wTablename.setText(Const.NVL((String)std.getTableName(), (String)""));
                }
            } else {
                MessageBox mb = new MessageBox(this.shell, 33);
                mb.setMessage(BaseMessages.getString(PKG, (String)"ActionEvalTableContent.ConnectionError2.DialogMessage", (String[])new String[0]));
                mb.setText(BaseMessages.getString(PKG, (String)"System.Dialog.Error.Title", (String[])new String[0]));
                mb.open();
            }
        }
    }
}

