/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.parquet.transforms.output;

import org.apache.hop.core.Const;
import org.apache.hop.core.logging.LogChannel;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.parquet.transforms.output.ParquetField;
import org.apache.hop.parquet.transforms.output.ParquetOutputMeta;
import org.apache.hop.parquet.transforms.output.ParquetVersion;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.gui.WindowProperty;
import org.apache.hop.ui.core.widget.ColumnInfo;
import org.apache.hop.ui.core.widget.TableView;
import org.apache.hop.ui.core.widget.TextVar;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.apache.parquet.hadoop.metadata.CompressionCodecName;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class ParquetOutputDialog
extends BaseTransformDialog {
    public static final Class<?> PKG = ParquetOutputMeta.class;
    protected ParquetOutputMeta input;
    private TextVar wFilenameBase;
    private TextVar wFilenameExtension;
    private Button wFilenameIncludeDate;
    private Button wFilenameIncludeTime;
    private Button wFilenameIncludeDateTime;
    private Label wlFilenameDateTimeFormat;
    private TextVar wFilenameDateTimeFormat;
    private Button wFilenameIncludeCopyNr;
    private Button wFilenameIncludeSplitNr;
    private Label wlFilenameSplitSize;
    private TextVar wFilenameSplitSize;
    private Button wFilenameCreateFolders;
    private Combo wCompressionCodec;
    private Combo wVersion;
    private TextVar wRowGroupSize;
    private TextVar wDataPageSize;
    private TextVar wDictionaryPageSize;
    private TableView wFields;
    private String returnValue;

    public ParquetOutputDialog(Shell parent, IVariables variables, ParquetOutputMeta transformMeta, PipelineMeta pipelineMeta) {
        super(parent, variables, (ITransformMeta)transformMeta, pipelineMeta);
        this.input = transformMeta;
    }

    public String open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        PropsUi.setLook((Widget)this.shell);
        this.setShellImage(this.shell, (ITransformMeta)this.input);
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = PropsUi.getFormMargin();
        formLayout.marginHeight = PropsUi.getFormMargin();
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"ParquetOutput.Name", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = PropsUi.getMargin();
        this.wOk = new Button((Composite)this.shell, 8);
        this.wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wOk.addListener(13, e -> this.ok());
        this.wGet = new Button((Composite)this.shell, 8);
        this.wGet.setText(BaseMessages.getString(PKG, (String)"System.Button.GetFields", (String[])new String[0]));
        this.wGet.addListener(13, e -> this.getFields());
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.wCancel.addListener(13, e -> this.cancel());
        this.setButtonPositions(new Button[]{this.wOk, this.wGet, this.wCancel}, margin, null);
        this.wlTransformName = new Label((Composite)this.shell, 131072);
        this.wlTransformName.setText(BaseMessages.getString(PKG, (String)"ParquetOutputDialog.TransformName.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlTransformName);
        this.fdlTransformName = new FormData();
        this.fdlTransformName.left = new FormAttachment(0, 0);
        this.fdlTransformName.right = new FormAttachment(middle, -margin);
        this.fdlTransformName.top = new FormAttachment(0, margin);
        this.wlTransformName.setLayoutData((Object)this.fdlTransformName);
        this.wTransformName = new Text((Composite)this.shell, 18436);
        this.wTransformName.setText(this.transformName);
        PropsUi.setLook((Widget)this.wTransformName);
        this.fdTransformName = new FormData();
        this.fdTransformName.left = new FormAttachment(middle, 0);
        this.fdTransformName.top = new FormAttachment((Control)this.wlTransformName, 0, 0x1000000);
        this.fdTransformName.right = new FormAttachment(100, 0);
        this.wTransformName.setLayoutData((Object)this.fdTransformName);
        Text lastControl = this.wTransformName;
        Group wFileGroup = new Group((Composite)this.shell, 16);
        wFileGroup.setText(BaseMessages.getString(PKG, (String)"ParquetOutputDialog.FilenameGroup.Label", (String[])new String[0]));
        wFileGroup.setLayout((Layout)new FormLayout());
        PropsUi.setLook((Widget)wFileGroup);
        FormData fdFileGroup = new FormData();
        fdFileGroup.left = new FormAttachment(0, 0);
        fdFileGroup.right = new FormAttachment(100, 0);
        fdFileGroup.top = new FormAttachment((Control)lastControl, margin);
        wFileGroup.setLayoutData((Object)fdFileGroup);
        Label wlFilenameBase = new Label((Composite)wFileGroup, 131072);
        wlFilenameBase.setText(BaseMessages.getString(PKG, (String)"ParquetOutputDialog.FilenameBase.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlFilenameBase);
        FormData fdlFilenameBase = new FormData();
        fdlFilenameBase.left = new FormAttachment(0, 0);
        fdlFilenameBase.right = new FormAttachment(middle, -margin);
        fdlFilenameBase.top = new FormAttachment(0, 0);
        wlFilenameBase.setLayoutData((Object)fdlFilenameBase);
        this.wFilenameBase = new TextVar(this.variables, (Composite)wFileGroup, 18436);
        PropsUi.setLook((Widget)this.wFilenameBase);
        FormData fdFilenameBase = new FormData();
        fdFilenameBase.left = new FormAttachment(middle, 0);
        fdFilenameBase.top = new FormAttachment((Control)wlFilenameBase, 0, 0x1000000);
        fdFilenameBase.right = new FormAttachment(100, 0);
        this.wFilenameBase.setLayoutData((Object)fdFilenameBase);
        lastControl = this.wFilenameBase;
        Label wlFilenameExtension = new Label((Composite)wFileGroup, 131072);
        wlFilenameExtension.setText(BaseMessages.getString(PKG, (String)"ParquetOutputDialog.FilenameExtension.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlFilenameExtension);
        FormData fdlFilenameExtension = new FormData();
        fdlFilenameExtension.left = new FormAttachment(0, 0);
        fdlFilenameExtension.right = new FormAttachment(middle, -margin);
        fdlFilenameExtension.top = new FormAttachment((Control)lastControl, margin);
        wlFilenameExtension.setLayoutData((Object)fdlFilenameExtension);
        this.wFilenameExtension = new TextVar(this.variables, (Composite)wFileGroup, 18436);
        PropsUi.setLook((Widget)this.wFilenameExtension);
        FormData fdFilenameExtension = new FormData();
        fdFilenameExtension.left = new FormAttachment(middle, 0);
        fdFilenameExtension.top = new FormAttachment((Control)wlFilenameExtension, 0, 0x1000000);
        fdFilenameExtension.right = new FormAttachment(100, 0);
        this.wFilenameExtension.setLayoutData((Object)fdFilenameExtension);
        lastControl = this.wFilenameExtension;
        Label wlFilenameIncludeDate = new Label((Composite)wFileGroup, 131072);
        wlFilenameIncludeDate.setText(BaseMessages.getString(PKG, (String)"ParquetOutputDialog.FilenameIncludeDate.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlFilenameIncludeDate);
        FormData fdlFilenameIncludeDate = new FormData();
        fdlFilenameIncludeDate.left = new FormAttachment(0, 0);
        fdlFilenameIncludeDate.right = new FormAttachment(middle, -margin);
        fdlFilenameIncludeDate.top = new FormAttachment((Control)lastControl, margin);
        wlFilenameIncludeDate.setLayoutData((Object)fdlFilenameIncludeDate);
        this.wFilenameIncludeDate = new Button((Composite)wFileGroup, 32);
        PropsUi.setLook((Widget)this.wFilenameIncludeDate);
        FormData fdFilenameIncludeDate = new FormData();
        fdFilenameIncludeDate.left = new FormAttachment(middle, 0);
        fdFilenameIncludeDate.top = new FormAttachment((Control)wlFilenameIncludeDate, 0, 0x1000000);
        fdFilenameIncludeDate.right = new FormAttachment(100, 0);
        this.wFilenameIncludeDate.setLayoutData((Object)fdFilenameIncludeDate);
        lastControl = wlFilenameIncludeDate;
        Label wlFilenameIncludeTime = new Label((Composite)wFileGroup, 131072);
        wlFilenameIncludeTime.setText(BaseMessages.getString(PKG, (String)"ParquetOutputDialog.FilenameIncludeTime.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlFilenameIncludeTime);
        FormData fdlFilenameIncludeTime = new FormData();
        fdlFilenameIncludeTime.left = new FormAttachment(0, 0);
        fdlFilenameIncludeTime.right = new FormAttachment(middle, -margin);
        fdlFilenameIncludeTime.top = new FormAttachment((Control)lastControl, margin);
        wlFilenameIncludeTime.setLayoutData((Object)fdlFilenameIncludeTime);
        this.wFilenameIncludeTime = new Button((Composite)wFileGroup, 32);
        PropsUi.setLook((Widget)this.wFilenameIncludeTime);
        FormData fdFilenameIncludeTime = new FormData();
        fdFilenameIncludeTime.left = new FormAttachment(middle, 0);
        fdFilenameIncludeTime.top = new FormAttachment((Control)wlFilenameIncludeTime, 0, 0x1000000);
        fdFilenameIncludeTime.right = new FormAttachment(100, 0);
        this.wFilenameIncludeTime.setLayoutData((Object)fdFilenameIncludeTime);
        lastControl = wlFilenameIncludeTime;
        Label wlFilenameIncludeDateTime = new Label((Composite)wFileGroup, 131072);
        wlFilenameIncludeDateTime.setText(BaseMessages.getString(PKG, (String)"ParquetOutputDialog.FilenameIncludeDateTime.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlFilenameIncludeDateTime);
        FormData fdlFilenameIncludeDateTime = new FormData();
        fdlFilenameIncludeDateTime.left = new FormAttachment(0, 0);
        fdlFilenameIncludeDateTime.right = new FormAttachment(middle, -margin);
        fdlFilenameIncludeDateTime.top = new FormAttachment((Control)lastControl, margin);
        wlFilenameIncludeDateTime.setLayoutData((Object)fdlFilenameIncludeDateTime);
        this.wFilenameIncludeDateTime = new Button((Composite)wFileGroup, 32);
        PropsUi.setLook((Widget)this.wFilenameIncludeDateTime);
        FormData fdFilenameIncludeDateTime = new FormData();
        fdFilenameIncludeDateTime.left = new FormAttachment(middle, 0);
        fdFilenameIncludeDateTime.top = new FormAttachment((Control)wlFilenameIncludeDateTime, 0, 0x1000000);
        fdFilenameIncludeDateTime.right = new FormAttachment(100, 0);
        this.wFilenameIncludeDateTime.setLayoutData((Object)fdFilenameIncludeDateTime);
        this.wFilenameIncludeDateTime.addListener(13, e -> this.enableFields());
        lastControl = wlFilenameIncludeDateTime;
        this.wlFilenameDateTimeFormat = new Label((Composite)wFileGroup, 131072);
        this.wlFilenameDateTimeFormat.setText(BaseMessages.getString(PKG, (String)"ParquetOutputDialog.FilenameDateTimeFormat.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlFilenameDateTimeFormat);
        FormData fdlFilenameDateTimeFormat = new FormData();
        fdlFilenameDateTimeFormat.left = new FormAttachment(0, 0);
        fdlFilenameDateTimeFormat.right = new FormAttachment(middle, -margin);
        fdlFilenameDateTimeFormat.top = new FormAttachment((Control)lastControl, margin);
        this.wlFilenameDateTimeFormat.setLayoutData((Object)fdlFilenameDateTimeFormat);
        this.wFilenameDateTimeFormat = new TextVar(this.variables, (Composite)wFileGroup, 18436);
        PropsUi.setLook((Widget)this.wFilenameDateTimeFormat);
        FormData fdFilenameDateTimeFormat = new FormData();
        fdFilenameDateTimeFormat.left = new FormAttachment(middle, 0);
        fdFilenameDateTimeFormat.top = new FormAttachment((Control)this.wlFilenameDateTimeFormat, 0, 0x1000000);
        fdFilenameDateTimeFormat.right = new FormAttachment(100, 0);
        this.wFilenameDateTimeFormat.setLayoutData((Object)fdFilenameDateTimeFormat);
        lastControl = this.wFilenameDateTimeFormat;
        Label wlFilenameIncludeCopyNr = new Label((Composite)wFileGroup, 131072);
        wlFilenameIncludeCopyNr.setText(BaseMessages.getString(PKG, (String)"ParquetOutputDialog.FilenameIncludeCopyNr.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlFilenameIncludeCopyNr);
        FormData fdlFilenameIncludeCopyNr = new FormData();
        fdlFilenameIncludeCopyNr.left = new FormAttachment(0, 0);
        fdlFilenameIncludeCopyNr.right = new FormAttachment(middle, -margin);
        fdlFilenameIncludeCopyNr.top = new FormAttachment((Control)lastControl, margin);
        wlFilenameIncludeCopyNr.setLayoutData((Object)fdlFilenameIncludeCopyNr);
        this.wFilenameIncludeCopyNr = new Button((Composite)wFileGroup, 32);
        PropsUi.setLook((Widget)this.wFilenameIncludeCopyNr);
        FormData fdFilenameIncludeCopyNr = new FormData();
        fdFilenameIncludeCopyNr.left = new FormAttachment(middle, 0);
        fdFilenameIncludeCopyNr.top = new FormAttachment((Control)wlFilenameIncludeCopyNr, 0, 0x1000000);
        fdFilenameIncludeCopyNr.right = new FormAttachment(100, 0);
        this.wFilenameIncludeCopyNr.setLayoutData((Object)fdFilenameIncludeCopyNr);
        lastControl = wlFilenameIncludeCopyNr;
        Label wlFilenameIncludeSplitNr = new Label((Composite)wFileGroup, 131072);
        wlFilenameIncludeSplitNr.setText(BaseMessages.getString(PKG, (String)"ParquetOutputDialog.FilenameIncludeSplitNr.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlFilenameIncludeSplitNr);
        FormData fdlFilenameIncludeSplitNr = new FormData();
        fdlFilenameIncludeSplitNr.left = new FormAttachment(0, 0);
        fdlFilenameIncludeSplitNr.right = new FormAttachment(middle, -margin);
        fdlFilenameIncludeSplitNr.top = new FormAttachment((Control)lastControl, margin);
        wlFilenameIncludeSplitNr.setLayoutData((Object)fdlFilenameIncludeSplitNr);
        this.wFilenameIncludeSplitNr = new Button((Composite)wFileGroup, 32);
        PropsUi.setLook((Widget)this.wFilenameIncludeSplitNr);
        FormData fdFilenameIncludeSplitNr = new FormData();
        fdFilenameIncludeSplitNr.left = new FormAttachment(middle, 0);
        fdFilenameIncludeSplitNr.top = new FormAttachment((Control)wlFilenameIncludeSplitNr, 0, 0x1000000);
        fdFilenameIncludeSplitNr.right = new FormAttachment(100, 0);
        this.wFilenameIncludeSplitNr.setLayoutData((Object)fdFilenameIncludeSplitNr);
        this.wFilenameIncludeSplitNr.addListener(13, e -> this.enableFields());
        lastControl = wlFilenameIncludeSplitNr;
        this.wlFilenameSplitSize = new Label((Composite)wFileGroup, 131072);
        this.wlFilenameSplitSize.setText(BaseMessages.getString(PKG, (String)"ParquetOutputDialog.FilenameSplitSize.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlFilenameSplitSize);
        FormData fdlFilenameSplitSize = new FormData();
        fdlFilenameSplitSize.left = new FormAttachment(0, 0);
        fdlFilenameSplitSize.right = new FormAttachment(middle, -margin);
        fdlFilenameSplitSize.top = new FormAttachment((Control)lastControl, margin);
        this.wlFilenameSplitSize.setLayoutData((Object)fdlFilenameSplitSize);
        this.wFilenameSplitSize = new TextVar(this.variables, (Composite)wFileGroup, 18436);
        PropsUi.setLook((Widget)this.wFilenameSplitSize);
        FormData fdFilenameSplitSize = new FormData();
        fdFilenameSplitSize.left = new FormAttachment(middle, 0);
        fdFilenameSplitSize.top = new FormAttachment((Control)this.wlFilenameSplitSize, 0, 0x1000000);
        fdFilenameSplitSize.right = new FormAttachment(100, 0);
        this.wFilenameSplitSize.setLayoutData((Object)fdFilenameSplitSize);
        lastControl = this.wFilenameSplitSize;
        Label wlFilenameCreateFolders = new Label((Composite)wFileGroup, 131072);
        wlFilenameCreateFolders.setText(BaseMessages.getString(PKG, (String)"ParquetOutputDialog.FilenameCreateFolders.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlFilenameCreateFolders);
        FormData fdlFilenameCreateFolders = new FormData();
        fdlFilenameCreateFolders.left = new FormAttachment(0, 0);
        fdlFilenameCreateFolders.right = new FormAttachment(middle, -margin);
        fdlFilenameCreateFolders.top = new FormAttachment((Control)lastControl, margin);
        wlFilenameCreateFolders.setLayoutData((Object)fdlFilenameCreateFolders);
        this.wFilenameCreateFolders = new Button((Composite)wFileGroup, 32);
        PropsUi.setLook((Widget)this.wFilenameCreateFolders);
        FormData fdFilenameCreateFolders = new FormData();
        fdFilenameCreateFolders.left = new FormAttachment(middle, 0);
        fdFilenameCreateFolders.top = new FormAttachment((Control)wlFilenameCreateFolders, 0, 0x1000000);
        fdFilenameCreateFolders.right = new FormAttachment(100, 0);
        this.wFilenameCreateFolders.setLayoutData((Object)fdFilenameCreateFolders);
        lastControl = wFileGroup;
        Label wlCompressionCodec = new Label((Composite)this.shell, 131072);
        wlCompressionCodec.setText(BaseMessages.getString(PKG, (String)"ParquetOutputDialog.CompressionCodec.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlCompressionCodec);
        FormData fdlCompressionCodec = new FormData();
        fdlCompressionCodec.left = new FormAttachment(0, 0);
        fdlCompressionCodec.right = new FormAttachment(middle, -margin);
        fdlCompressionCodec.top = new FormAttachment((Control)lastControl, margin);
        wlCompressionCodec.setLayoutData((Object)fdlCompressionCodec);
        this.wCompressionCodec = new Combo((Composite)this.shell, 18436);
        for (CompressionCodecName compressionCodecName : CompressionCodecName.values()) {
            this.wCompressionCodec.add(compressionCodecName.name());
        }
        PropsUi.setLook((Widget)this.wCompressionCodec);
        FormData fdCompressionCodec = new FormData();
        fdCompressionCodec.left = new FormAttachment(middle, 0);
        fdCompressionCodec.top = new FormAttachment((Control)wlCompressionCodec, 0, 0x1000000);
        fdCompressionCodec.right = new FormAttachment(100, 0);
        this.wCompressionCodec.setLayoutData((Object)fdCompressionCodec);
        lastControl = this.wCompressionCodec;
        Label wlVersion = new Label((Composite)this.shell, 131072);
        wlVersion.setText(BaseMessages.getString(PKG, (String)"ParquetOutputDialog.Version.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlVersion);
        FormData fdlVersion = new FormData();
        fdlVersion.left = new FormAttachment(0, 0);
        fdlVersion.right = new FormAttachment(middle, -margin);
        fdlVersion.top = new FormAttachment((Control)lastControl, margin);
        wlVersion.setLayoutData((Object)fdlVersion);
        this.wVersion = new Combo((Composite)this.shell, 18436);
        for (ParquetVersion version : ParquetVersion.values()) {
            this.wVersion.add(version.getDescription());
        }
        PropsUi.setLook((Widget)this.wVersion);
        FormData formData = new FormData();
        formData.left = new FormAttachment(middle, 0);
        formData.top = new FormAttachment((Control)wlVersion, 0, 0x1000000);
        formData.right = new FormAttachment(100, 0);
        this.wVersion.setLayoutData((Object)formData);
        lastControl = this.wVersion;
        Label wlRowGroupSize = new Label((Composite)this.shell, 131072);
        wlRowGroupSize.setText(BaseMessages.getString(PKG, (String)"ParquetOutputDialog.RowGroupSize.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlRowGroupSize);
        FormData fdlRowGroupSize = new FormData();
        fdlRowGroupSize.left = new FormAttachment(0, 0);
        fdlRowGroupSize.right = new FormAttachment(middle, -margin);
        fdlRowGroupSize.top = new FormAttachment((Control)lastControl, margin);
        wlRowGroupSize.setLayoutData((Object)fdlRowGroupSize);
        this.wRowGroupSize = new TextVar(this.variables, (Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wRowGroupSize);
        FormData fdRowGroupSize = new FormData();
        fdRowGroupSize.left = new FormAttachment(middle, 0);
        fdRowGroupSize.top = new FormAttachment((Control)wlRowGroupSize, 0, 0x1000000);
        fdRowGroupSize.right = new FormAttachment(100, 0);
        this.wRowGroupSize.setLayoutData((Object)fdRowGroupSize);
        lastControl = this.wRowGroupSize;
        Label wlDataPageSize = new Label((Composite)this.shell, 131072);
        wlDataPageSize.setText(BaseMessages.getString(PKG, (String)"ParquetOutputDialog.DataPageSize.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlDataPageSize);
        FormData fdlDataPageSize = new FormData();
        fdlDataPageSize.left = new FormAttachment(0, 0);
        fdlDataPageSize.right = new FormAttachment(middle, -margin);
        fdlDataPageSize.top = new FormAttachment((Control)lastControl, margin);
        wlDataPageSize.setLayoutData((Object)fdlDataPageSize);
        this.wDataPageSize = new TextVar(this.variables, (Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wDataPageSize);
        FormData fdDataPageSize = new FormData();
        fdDataPageSize.left = new FormAttachment(middle, 0);
        fdDataPageSize.top = new FormAttachment((Control)wlDataPageSize, 0, 0x1000000);
        fdDataPageSize.right = new FormAttachment(100, 0);
        this.wDataPageSize.setLayoutData((Object)fdDataPageSize);
        lastControl = this.wDataPageSize;
        Label wlDictionaryPageSize = new Label((Composite)this.shell, 131072);
        wlDictionaryPageSize.setText(BaseMessages.getString(PKG, (String)"ParquetOutputDialog.DictionaryPageSize.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlDictionaryPageSize);
        FormData fdlDictionaryPageSize = new FormData();
        fdlDictionaryPageSize.left = new FormAttachment(0, 0);
        fdlDictionaryPageSize.right = new FormAttachment(middle, -margin);
        fdlDictionaryPageSize.top = new FormAttachment((Control)lastControl, margin);
        wlDictionaryPageSize.setLayoutData((Object)fdlDictionaryPageSize);
        this.wDictionaryPageSize = new TextVar(this.variables, (Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wDictionaryPageSize);
        FormData fdDictionaryPageSize = new FormData();
        fdDictionaryPageSize.left = new FormAttachment(middle, 0);
        fdDictionaryPageSize.top = new FormAttachment((Control)wlDictionaryPageSize, 0, 0x1000000);
        fdDictionaryPageSize.right = new FormAttachment(100, 0);
        this.wDictionaryPageSize.setLayoutData((Object)fdDictionaryPageSize);
        lastControl = this.wDictionaryPageSize;
        Label wlFields = new Label((Composite)this.shell, 16384);
        wlFields.setText(BaseMessages.getString(PKG, (String)"ParquetOutputDialog.Fields.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlFields);
        FormData fdlFields = new FormData();
        fdlFields.left = new FormAttachment(0, 0);
        fdlFields.right = new FormAttachment(middle, -margin);
        fdlFields.top = new FormAttachment((Control)lastControl, margin);
        wlFields.setLayoutData((Object)fdlFields);
        ColumnInfo[] columns = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"ParquetOutputDialog.FieldsColumn.SourceField.Label", (String[])new String[0]), 2, new String[0]), new ColumnInfo(BaseMessages.getString(PKG, (String)"ParquetOutputDialog.FieldsColumn.TargetField.Label", (String[])new String[0]), 1, false, false)};
        this.wFields = new TableView(this.variables, (Composite)this.shell, 2048, columns, this.input.getFields().size(), false, null, this.props);
        PropsUi.setLook((Widget)this.wFields);
        FormData fdFields = new FormData();
        fdFields.left = new FormAttachment(0, 0);
        fdFields.top = new FormAttachment((Control)wlFields, margin);
        fdFields.right = new FormAttachment(100, 0);
        fdFields.bottom = new FormAttachment((Control)this.wOk, -2 * margin);
        this.wFields.setLayoutData((Object)fdFields);
        this.getData();
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.returnValue;
    }

    private void enableFields() {
        this.wlFilenameDateTimeFormat.setEnabled(this.wFilenameIncludeDateTime.getSelection());
        this.wFilenameDateTimeFormat.setEnabled(this.wFilenameIncludeDateTime.getSelection());
        this.wlFilenameSplitSize.setEnabled(this.wFilenameIncludeSplitNr.getSelection());
        this.wFilenameSplitSize.setEnabled(this.wFilenameIncludeSplitNr.getSelection());
    }

    private void getFields() {
        try {
            IRowMeta rowMeta = this.pipelineMeta.getPrevTransformFields(this.variables, this.transformName);
            BaseTransformDialog.getFieldsFromPrevious((IRowMeta)rowMeta, (TableView)this.wFields, (int)2, (int[])new int[]{1, 2}, (int[])new int[0], (int)-1, (int)-1, (boolean)true, null);
        }
        catch (Exception e) {
            new ErrorDialog(this.shell, "Error", "Error getting fields", e);
        }
    }

    private void getData() {
        try {
            IRowMeta fields = this.pipelineMeta.getPrevTransformFields(this.variables, this.transformName);
            this.wFields.getColumns()[0].setComboValues(fields.getFieldNames());
        }
        catch (Exception e) {
            LogChannel.UI.logError("Error getting source fields", (Throwable)e);
        }
        this.wTransformName.setText(Const.NVL((String)this.transformName, (String)""));
        this.wFilenameBase.setText(Const.NVL((String)this.input.getFilenameBase(), (String)""));
        this.wFilenameExtension.setText(Const.NVL((String)this.input.getFilenameExtension(), (String)""));
        this.wFilenameIncludeDate.setSelection(this.input.isFilenameIncludingDate());
        this.wFilenameIncludeTime.setSelection(this.input.isFilenameIncludingTime());
        this.wFilenameIncludeDateTime.setSelection(this.input.isFilenameIncludingDateTime());
        this.wFilenameDateTimeFormat.setText(Const.NVL((String)this.input.getFilenameDateTimeFormat(), (String)""));
        this.wFilenameIncludeCopyNr.setSelection(this.input.isFilenameIncludingCopyNr());
        this.wFilenameIncludeSplitNr.setSelection(this.input.isFilenameIncludingSplitNr());
        this.wFilenameSplitSize.setText(Const.NVL((String)this.input.getFileSplitSize(), (String)""));
        this.wFilenameCreateFolders.setSelection(this.input.isFilenameCreatingParentFolders());
        this.wCompressionCodec.setText(this.input.getCompressionCodec().name());
        this.wVersion.setText(this.input.getVersion().getDescription());
        this.wRowGroupSize.setText(Const.NVL((String)this.input.getRowGroupSize(), (String)""));
        this.wDataPageSize.setText(Const.NVL((String)this.input.getDataPageSize(), (String)""));
        this.wDictionaryPageSize.setText(Const.NVL((String)this.input.getDictionaryPageSize(), (String)""));
        for (int i = 0; i < this.input.getFields().size(); ++i) {
            ParquetField field = this.input.getFields().get(i);
            TableItem item = this.wFields.table.getItem(i);
            item.setText(1, Const.NVL((String)field.getSourceFieldName(), (String)""));
            item.setText(2, Const.NVL((String)field.getTargetFieldName(), (String)""));
        }
        this.wFields.optimizeTableView();
        this.enableFields();
    }

    private void ok() {
        this.returnValue = this.wTransformName.getText();
        this.input.setFilenameBase(this.wFilenameBase.getText());
        this.input.setFilenameExtension(this.wFilenameExtension.getText());
        this.input.setFilenameIncludingDate(this.wFilenameIncludeDate.getSelection());
        this.input.setFilenameIncludingTime(this.wFilenameIncludeTime.getSelection());
        this.input.setFilenameIncludingDateTime(this.wFilenameIncludeDateTime.getSelection());
        this.input.setFilenameDateTimeFormat(this.wFilenameDateTimeFormat.getText());
        this.input.setFilenameIncludingCopyNr(this.wFilenameIncludeCopyNr.getSelection());
        this.input.setFilenameIncludingSplitNr(this.wFilenameIncludeSplitNr.getSelection());
        this.input.setFileSplitSize(this.wFilenameSplitSize.getText());
        this.input.setFilenameCreatingParentFolders(this.wFilenameCreateFolders.getSelection());
        CompressionCodecName codec = CompressionCodecName.UNCOMPRESSED;
        try {
            codec = CompressionCodecName.valueOf((String)this.wCompressionCodec.getText());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.input.setCompressionCodec(codec);
        this.input.setVersion(ParquetVersion.getVersionFromDescription(this.wVersion.getText()));
        this.input.setRowGroupSize(this.wRowGroupSize.getText());
        this.input.setDataPageSize(this.wDataPageSize.getText());
        this.input.setDictionaryPageSize(this.wDictionaryPageSize.getText());
        this.input.getFields().clear();
        for (TableItem item : this.wFields.getNonEmptyItems()) {
            this.input.getFields().add(new ParquetField(item.getText(1), item.getText(2)));
        }
        this.input.setChanged();
        this.dispose();
    }

    private void cancel() {
        this.returnValue = null;
        this.dispose();
    }

    public void dispose() {
        this.props.setScreen(new WindowProperty(this.shell));
        this.shell.dispose();
    }
}

