/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.core.row.value;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.math.BigDecimal;
import java.net.SocketTimeoutException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.apache.hop.core.Const;
import org.apache.hop.core.database.DatabaseMeta;
import org.apache.hop.core.database.IDatabase;
import org.apache.hop.core.exception.HopDatabaseException;
import org.apache.hop.core.exception.HopEofException;
import org.apache.hop.core.exception.HopFileException;
import org.apache.hop.core.exception.HopValueException;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.value.ValueMetaDate;
import org.apache.hop.core.row.value.ValueMetaPlugin;
import org.apache.hop.core.row.value.timestamp.SimpleTimestampFormat;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;

@ValueMetaPlugin(id="9", name="Timestamp", description="Timestamp", image="images/timestamp.svg")
public class ValueMetaTimestamp
extends ValueMetaDate {
    private static final String CONST_SPECIFIED = " specified.";
    private static final String CONST_UNKNOWN_TYPE = " : Unknown storage type ";

    public ValueMetaTimestamp() {
        this((String)null);
    }

    public ValueMetaTimestamp(String name) {
        super(name, 9);
    }

    @Override
    public boolean isDate() {
        return true;
    }

    @Override
    public Date getDate(Object object) throws HopValueException {
        return this.getTimestamp(object);
    }

    @Override
    public Long getInteger(Object object) throws HopValueException {
        Timestamp timestamp = this.getTimestamp(object);
        if (timestamp == null) {
            return null;
        }
        return timestamp.getTime();
    }

    @Override
    public Double getNumber(Object object) throws HopValueException {
        Timestamp timestamp = this.getTimestamp(object);
        if (timestamp == null) {
            return null;
        }
        return timestamp.getTime();
    }

    @Override
    public BigDecimal getBigNumber(Object object) throws HopValueException {
        Timestamp timestamp = this.getTimestamp(object);
        if (timestamp == null) {
            return null;
        }
        return BigDecimal.valueOf(timestamp.getTime()).multiply(BigDecimal.valueOf(1000000000L)).add(BigDecimal.valueOf(timestamp.getNanos()));
    }

    @Override
    public Boolean getBoolean(Object object) throws HopValueException {
        throw new HopValueException(this.toStringMeta() + ": it's not possible to convert from Timestamp to Boolean");
    }

    @Override
    public String getString(Object object) throws HopValueException {
        return this.convertTimestampToString(this.getTimestamp(object));
    }

    public Timestamp getTimestamp(Object object) throws HopValueException {
        if (object == null) {
            return null;
        }
        switch (this.type) {
            case 9: {
                switch (this.storageType) {
                    case 0: {
                        return (Timestamp)object;
                    }
                    case 1: {
                        return (Timestamp)this.convertBinaryStringToNativeType((byte[])object);
                    }
                    case 2: {
                        return (Timestamp)this.index[(Integer)object];
                    }
                }
                throw new HopValueException(String.valueOf(this) + CONST_UNKNOWN_TYPE + this.storageType + CONST_SPECIFIED);
            }
            case 2: {
                switch (this.storageType) {
                    case 0: {
                        return this.convertStringToTimestamp((String)object);
                    }
                    case 1: {
                        return this.convertStringToTimestamp((String)this.convertBinaryStringToNativeType((byte[])object));
                    }
                    case 2: {
                        return this.convertStringToTimestamp((String)this.index[(Integer)object]);
                    }
                }
                throw new HopValueException(String.valueOf(this) + CONST_UNKNOWN_TYPE + this.storageType + CONST_SPECIFIED);
            }
            case 1: {
                switch (this.storageType) {
                    case 0: {
                        return this.convertNumberToTimestamp((Double)object);
                    }
                    case 1: {
                        return this.convertNumberToTimestamp((Double)this.convertBinaryStringToNativeType((byte[])object));
                    }
                    case 2: {
                        return this.convertNumberToTimestamp((Double)this.index[(Integer)object]);
                    }
                }
                throw new HopValueException(String.valueOf(this) + CONST_UNKNOWN_TYPE + this.storageType + CONST_SPECIFIED);
            }
            case 5: {
                switch (this.storageType) {
                    case 0: {
                        return this.convertIntegerToTimestamp((Long)object);
                    }
                    case 1: {
                        return this.convertIntegerToTimestamp((Long)this.convertBinaryStringToNativeType((byte[])object));
                    }
                    case 2: {
                        return this.convertIntegerToTimestamp((Long)this.index[(Integer)object]);
                    }
                }
                throw new HopValueException(String.valueOf(this) + CONST_UNKNOWN_TYPE + this.storageType + CONST_SPECIFIED);
            }
            case 6: {
                switch (this.storageType) {
                    case 0: {
                        return this.convertBigNumberToTimestamp((BigDecimal)object);
                    }
                    case 1: {
                        return this.convertBigNumberToTimestamp((BigDecimal)this.convertBinaryStringToNativeType((byte[])object));
                    }
                    case 2: {
                        return this.convertBigNumberToTimestamp((BigDecimal)this.index[(Integer)object]);
                    }
                }
                throw new HopValueException(String.valueOf(this) + CONST_UNKNOWN_TYPE + this.storageType + CONST_SPECIFIED);
            }
            case 4: {
                throw new HopValueException(String.valueOf(this) + " : I don't know how to convert a boolean to a timestamp.");
            }
            case 8: {
                throw new HopValueException(String.valueOf(this) + " : I don't know how to convert a binary value to timestamp.");
            }
            case 7: {
                throw new HopValueException(String.valueOf(this) + " : I don't know how to convert a serializable value to timestamp.");
            }
        }
        throw new HopValueException(String.valueOf(this) + " : Unknown type " + this.type + CONST_SPECIFIED);
    }

    @Override
    public int compare(Object data1, Object data2) throws HopValueException {
        Timestamp timestamp1 = this.getTimestamp(data1);
        Timestamp timestamp2 = this.getTimestamp(data2);
        int cmp = 0;
        cmp = timestamp1 == null ? (timestamp2 == null ? 0 : -1) : (timestamp2 == null ? 1 : timestamp1.compareTo(timestamp2));
        if (this.isSortedDescending()) {
            return -cmp;
        }
        return cmp;
    }

    protected Timestamp convertBigNumberToTimestamp(BigDecimal bd) {
        if (bd == null) {
            return null;
        }
        return this.convertIntegerToTimestamp(bd.longValue());
    }

    protected Timestamp convertNumberToTimestamp(Double d) {
        if (d == null) {
            return null;
        }
        long nanos = d.longValue();
        return this.convertIntegerToTimestamp(nanos);
    }

    protected Timestamp convertIntegerToTimestamp(Long nanos) {
        if (nanos == null) {
            return null;
        }
        long msSinceEpoch = nanos / 1000000L;
        int leftNanos = (int)(nanos - msSinceEpoch * 1000000L);
        Timestamp timestamp = new Timestamp(msSinceEpoch);
        timestamp.setNanos(leftNanos);
        return timestamp;
    }

    protected synchronized Timestamp convertStringToTimestamp(String string) throws HopValueException {
        Timestamp returnValue;
        if (Utils.isEmpty(string = Const.trimToType(string, this.getTrimType()))) {
            return null;
        }
        try {
            returnValue = Timestamp.valueOf(string);
        }
        catch (IllegalArgumentException e) {
            try {
                returnValue = (Timestamp)this.getDateFormat().parse(string);
            }
            catch (ParseException ex) {
                throw new HopValueException(String.valueOf(this) + " : couldn't convert string [" + string + "] to a timestamp, expecting format [yyyy-mm-dd hh:mm:ss.ffffff]", e);
            }
        }
        return returnValue;
    }

    protected synchronized String convertTimestampToString(Timestamp timestamp) {
        if (timestamp == null) {
            return null;
        }
        return this.getDateFormat().format(timestamp);
    }

    @Override
    public Object convertDataFromString(String pol, IValueMeta convertMeta, String nullIf, String ifNull, int trimType) throws HopValueException {
        String nullValue = nullIf;
        if (nullValue == null) {
            switch (convertMeta.getType()) {
                case 4: {
                    nullValue = "";
                    break;
                }
                case 2: {
                    nullValue = "";
                    break;
                }
                case 6: {
                    nullValue = "";
                    break;
                }
                case 1: {
                    nullValue = "";
                    break;
                }
                case 5: {
                    nullValue = "";
                    break;
                }
                case 3: {
                    nullValue = "";
                    break;
                }
                case 8: {
                    nullValue = "";
                    break;
                }
                default: {
                    nullValue = "";
                }
            }
        }
        if (!Utils.isEmpty(ifNull) && (Utils.isEmpty(pol) || pol.equalsIgnoreCase(Const.rightPad(new StringBuilder(nullValue), pol.length())))) {
            pol = ifNull;
        }
        if (Utils.isEmpty(pol)) {
            return null;
        }
        if (!Utils.isEmpty(nullValue) ? nullValue.length() <= pol.length() && pol.equalsIgnoreCase(Const.rightPad(new StringBuilder(nullValue), pol.length())) : Const.onlySpaces(pol)) {
            return null;
        }
        switch (trimType) {
            case 1: {
                StringBuilder strpol = new StringBuilder(pol);
                while (strpol.length() > 0 && strpol.charAt(0) == ' ') {
                    strpol.deleteCharAt(0);
                }
                pol = strpol.toString();
                break;
            }
            case 2: {
                StringBuilder strpol = new StringBuilder(pol);
                while (strpol.length() > 0 && strpol.charAt(strpol.length() - 1) == ' ') {
                    strpol.deleteCharAt(strpol.length() - 1);
                }
                pol = strpol.toString();
                break;
            }
            case 3: {
                StringBuilder strpol = new StringBuilder(pol);
                while (strpol.length() > 0 && strpol.charAt(0) == ' ') {
                    strpol.deleteCharAt(0);
                }
                while (strpol.length() > 0 && strpol.charAt(strpol.length() - 1) == ' ') {
                    strpol.deleteCharAt(strpol.length() - 1);
                }
                pol = strpol.toString();
                break;
            }
        }
        return this.convertData(convertMeta, pol);
    }

    public Timestamp convertDateToTimestamp(Date date) {
        Timestamp timestamp;
        if (date == null) {
            return null;
        }
        Timestamp result = null;
        result = date instanceof Timestamp ? (timestamp = (Timestamp)date) : new Timestamp(date.getTime());
        return result;
    }

    @Override
    public Object convertData(IValueMeta meta2, Object data2) throws HopValueException {
        switch (meta2.getType()) {
            case 9: {
                return ((ValueMetaTimestamp)meta2).getTimestamp(data2);
            }
            case 2: {
                return this.convertStringToTimestamp(meta2.getString(data2));
            }
            case 5: {
                return this.convertIntegerToTimestamp(meta2.getInteger(data2));
            }
            case 1: {
                return this.convertNumberToTimestamp(meta2.getNumber(data2));
            }
            case 3: {
                return this.convertDateToTimestamp(meta2.getDate(data2));
            }
            case 6: {
                return this.convertBigNumberToTimestamp(meta2.getBigNumber(data2));
            }
        }
        throw new HopValueException(meta2.toStringMeta() + " : can't be converted to a timestamp");
    }

    @Override
    public Object cloneValueData(Object object) throws HopValueException {
        Timestamp timestamp = this.getTimestamp(object);
        if (timestamp == null) {
            return null;
        }
        Timestamp clone = new Timestamp(timestamp.getTime());
        clone.setNanos(timestamp.getNanos());
        return clone;
    }

    @Override
    public IValueMeta getMetadataPreview(IVariables variables, DatabaseMeta databaseMeta, ResultSet rs) throws HopDatabaseException {
        try {
            if (93 == rs.getInt("COLUMN_TYPE")) {
                IValueMeta vmi = super.getMetadataPreview(variables, databaseMeta, rs);
                ValueMetaDate valueMeta = databaseMeta.supportsTimestampDataType() ? new ValueMetaTimestamp(this.name) : new ValueMetaDate(this.name);
                valueMeta.setLength(vmi.getLength());
                valueMeta.setOriginalColumnType(vmi.getOriginalColumnType());
                valueMeta.setOriginalColumnTypeName(vmi.getOriginalColumnTypeName());
                valueMeta.setOriginalNullable(vmi.getOriginalNullable());
                valueMeta.setOriginalPrecision(vmi.getOriginalPrecision());
                valueMeta.setOriginalScale(vmi.getOriginalScale());
                valueMeta.setOriginalSigned(vmi.getOriginalSigned());
                return valueMeta;
            }
        }
        catch (SQLException e) {
            throw new HopDatabaseException(e);
        }
        return null;
    }

    @Override
    public IValueMeta getValueFromSqlType(IVariables variables, DatabaseMeta databaseMeta, String name, ResultSetMetaData rm, int index, boolean ignoreLength, boolean lazyConversion) throws HopDatabaseException {
        try {
            int type = rm.getColumnType(index);
            if (type == 93) {
                int length = rm.getScale(index);
                ValueMetaDate valueMeta = databaseMeta.supportsTimestampDataType() ? new ValueMetaTimestamp(name) : new ValueMetaDate(name);
                valueMeta.setLength(length);
                this.getOriginalColumnMetadata(valueMeta, rm, index, ignoreLength);
                return valueMeta;
            }
            return null;
        }
        catch (Exception e) {
            throw new HopDatabaseException("Error evaluating timestamp value metadata", e);
        }
    }

    @Override
    public Object getValueFromResultSet(IDatabase iDatabase, ResultSet resultSet, int index) throws HopDatabaseException {
        try {
            return resultSet.getTimestamp(index + 1);
        }
        catch (Exception e) {
            throw new HopDatabaseException(this.toStringMeta() + " : Unable to get timestamp from resultset at index " + index, e);
        }
    }

    @Override
    public void setPreparedStatementValue(DatabaseMeta databaseMeta, PreparedStatement preparedStatement, int index, Object data) throws HopDatabaseException {
        try {
            if (data != null) {
                preparedStatement.setTimestamp(index, this.getTimestamp(data));
            } else {
                preparedStatement.setNull(index, 93);
            }
        }
        catch (Exception e) {
            throw new HopDatabaseException(this.toStringMeta() + " : Unable to set value on prepared statement on index " + index, e);
        }
    }

    @Override
    public Object convertDataUsingConversionMetaData(Object data2) throws HopValueException {
        if (this.conversionMetadata == null) {
            throw new HopValueException("API coding error: please specify the conversion metadata before attempting to convert value " + this.name);
        }
        return super.convertDataUsingConversionMetaData(data2);
    }

    @Override
    public byte[] getBinaryString(Object object) throws HopValueException {
        if (object == null) {
            return null;
        }
        if (this.isStorageBinaryString() && this.identicalFormat) {
            return (byte[])object;
        }
        switch (this.storageType) {
            case 0: {
                return this.convertStringToBinaryString(this.getString(object));
            }
            case 1: {
                return this.convertStringToBinaryString((String)this.convertBinaryStringToNativeType((byte[])object));
            }
            case 2: {
                return this.convertStringToBinaryString(this.getString(this.index[(Integer)object]));
            }
        }
        throw new HopValueException(String.valueOf(this) + CONST_UNKNOWN_TYPE + this.storageType + CONST_SPECIFIED);
    }

    @Override
    public void writeData(DataOutputStream outputStream, Object object) throws HopFileException {
        try {
            outputStream.writeBoolean(object == null);
            if (object != null) {
                switch (this.storageType) {
                    case 0: {
                        Timestamp timestamp = this.convertDateToTimestamp((Date)object);
                        outputStream.writeLong(timestamp.getTime());
                        outputStream.writeInt(timestamp.getNanos());
                        break;
                    }
                    case 1: {
                        this.writeBinaryString(outputStream, (byte[])object);
                        break;
                    }
                    case 2: {
                        this.writeInteger(outputStream, (Integer)object);
                        break;
                    }
                    default: {
                        throw new HopFileException(String.valueOf(this) + CONST_UNKNOWN_TYPE + this.getStorageType());
                    }
                }
            }
        }
        catch (ClassCastException e) {
            throw new RuntimeException(String.valueOf(this) + " : There was a data type error: the data type of " + object.getClass().getName() + " object [" + String.valueOf(object) + "] does not correspond to value meta [" + this.toStringMeta() + "]");
        }
        catch (IOException e) {
            throw new HopFileException(String.valueOf(this) + " : Unable to write value timestamp data to output stream", e);
        }
    }

    @Override
    public Object readData(DataInputStream inputStream) throws HopFileException, SocketTimeoutException {
        try {
            if (inputStream.readBoolean()) {
                return null;
            }
            switch (this.storageType) {
                case 0: {
                    long time = inputStream.readLong();
                    int nanos = inputStream.readInt();
                    Timestamp timestamp = new Timestamp(time);
                    timestamp.setNanos(nanos);
                    return timestamp;
                }
                case 1: {
                    return this.readBinaryString(inputStream);
                }
                case 2: {
                    return this.readSmallInteger(inputStream);
                }
            }
            throw new HopFileException(String.valueOf(this) + CONST_UNKNOWN_TYPE + this.getStorageType());
        }
        catch (EOFException e) {
            throw new HopEofException(e);
        }
        catch (SocketTimeoutException e) {
            throw e;
        }
        catch (IOException e) {
            throw new HopFileException(String.valueOf(this) + " : Unable to read value timestamp data from input stream", e);
        }
    }

    @Override
    public synchronized SimpleDateFormat getDateFormat() {
        return this.getDateFormat(this.getType());
    }

    private synchronized SimpleDateFormat getDateFormat(int valueMetaType) {
        if (this.conversionMetadata != null) {
            return new SimpleTimestampFormat(this.conversionMetadata.getDateFormat().toPattern());
        }
        if (this.dateFormat == null || this.dateFormatChanged) {
            this.dateFormat = new SimpleTimestampFormat(new SimpleDateFormat().toPattern());
            String mask = this.getMask(valueMetaType);
            this.dateFormat = this.dateFormatLocale == null || this.dateFormatLocale.equals(Locale.getDefault()) ? new SimpleTimestampFormat(mask) : new SimpleTimestampFormat(mask, this.dateFormatLocale);
            if (this.dateFormatTimeZone != null) {
                this.dateFormat.setTimeZone(this.dateFormatTimeZone);
            }
            this.dateFormat.setLenient(this.dateFormatLenient);
            this.dateFormatChanged = false;
        }
        return this.dateFormat;
    }

    @Override
    public String getFormatMask() {
        return this.getTimestampFormatMask();
    }

    @Override
    public Class<?> getNativeDataTypeClass() throws HopValueException {
        return Timestamp.class;
    }
}

