/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.csvinput;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.ByteOrderMark;
import org.apache.commons.io.input.BOMInputStream;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.provider.local.LocalFile;
import org.apache.hop.core.ResultFile;
import org.apache.hop.core.exception.HopConversionException;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopFileException;
import org.apache.hop.core.exception.HopValueException;
import org.apache.hop.core.file.EncodingType;
import org.apache.hop.core.file.TextFileInputField;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.RowDataUtil;
import org.apache.hop.core.row.RowMeta;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransform;
import org.apache.hop.pipeline.transform.ITransformData;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.csvinput.CsvInputData;
import org.apache.hop.pipeline.transforms.csvinput.CsvInputMeta;
import org.apache.hop.pipeline.transforms.csvinput.EmptyPatternMatcher;
import org.apache.hop.pipeline.transforms.csvinput.IFieldsMapping;
import org.apache.hop.pipeline.transforms.csvinput.MultiByteBigCrLfMatcher;
import org.apache.hop.pipeline.transforms.csvinput.MultiByteLittleCrLfMatcher;
import org.apache.hop.pipeline.transforms.csvinput.MultiBytePatternMatcher;
import org.apache.hop.pipeline.transforms.csvinput.NamedFieldsMapping;
import org.apache.hop.pipeline.transforms.csvinput.SingleByteCrLfMatcher;
import org.apache.hop.pipeline.transforms.csvinput.SingleBytePatternMatcher;
import org.apache.hop.pipeline.transforms.csvinput.UnnamedFieldsMapping;
import org.apache.hop.pipeline.transforms.fileinput.TextFileInput;
import org.apache.hop.pipeline.transforms.fileinput.text.BOMDetector;
import org.apache.hop.ui.pipeline.transform.common.TextFileLineUtil;

public class CsvInput
extends BaseTransform<CsvInputMeta, CsvInputData> {
    private static final Class<?> PKG = CsvInput.class;

    public CsvInput(TransformMeta transformMeta, CsvInputMeta meta, CsvInputData data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        super(transformMeta, (ITransformMeta)meta, (ITransformData)data, copyNr, pipelineMeta, pipeline);
    }

    public boolean processRow() throws HopException {
        if (this.first) {
            this.first = false;
            ((CsvInputData)this.data).outputRowMeta = new RowMeta();
            ((CsvInputMeta)this.meta).getFields(((CsvInputData)this.data).outputRowMeta, this.getTransformName(), null, null, (IVariables)this, this.metadataProvider);
            if (((CsvInputData)this.data).filenames == null) {
                this.getFilenamesFromPreviousTransforms();
            }
            ((CsvInputData)this.data).parallel = ((CsvInputMeta)this.meta).isRunningInParallel() && ((CsvInputData)this.data).totalNumberOfTransforms > 1;
            ((CsvInputData)this.data).convertRowMeta = ((CsvInputData)this.data).outputRowMeta.clone();
            for (IValueMeta valueMeta : ((CsvInputData)this.data).convertRowMeta.getValueMetaList()) {
                valueMeta.setStorageType(1);
            }
            ((CsvInputData)this.data).filenameFieldIndex = -1;
            if (!Utils.isEmpty((CharSequence)((CsvInputMeta)this.meta).getFilenameField()) && ((CsvInputMeta)this.meta).isIncludingFilename()) {
                ((CsvInputData)this.data).filenameFieldIndex = ((CsvInputMeta)this.meta).getInputFields().length;
            }
            ((CsvInputData)this.data).rownumFieldIndex = -1;
            if (!Utils.isEmpty((CharSequence)((CsvInputMeta)this.meta).getRowNumField())) {
                ((CsvInputData)this.data).rownumFieldIndex = ((CsvInputMeta)this.meta).getInputFields().length;
                if (((CsvInputData)this.data).filenameFieldIndex >= 0) {
                    ++((CsvInputData)this.data).rownumFieldIndex;
                }
            }
            if (((CsvInputData)this.data).parallel) {
                this.prepareToRunInParallel();
            }
            if (!this.openNextFile()) {
                this.setOutputDone();
                return false;
            }
        }
        if (((CsvInputData)this.data).parallel && ((CsvInputData)this.data).totalBytesRead >= ((CsvInputData)this.data).blockToRead) {
            this.setOutputDone();
            return false;
        }
        try {
            Object[] outputRowData = this.readOneRow(false, false);
            if (outputRowData == null) {
                if (this.openNextFile()) {
                    return true;
                }
                this.setOutputDone();
                return false;
            }
            this.putRow(((CsvInputData)this.data).outputRowMeta, outputRowData);
            if (this.checkFeedback(this.getLinesInput()) && this.isBasic()) {
                this.logBasic(BaseMessages.getString(PKG, (String)"CsvInput.Log.LineNumber", (String[])new String[]{Long.toString(this.getLinesInput())}));
            }
        }
        catch (HopConversionException e) {
            if (this.getTransformMeta().isDoingErrorHandling()) {
                StringBuilder errorDescriptions = new StringBuilder(100);
                StringBuilder errorFields = new StringBuilder(50);
                for (int i = 0; i < e.getCauses().size(); ++i) {
                    if (i > 0) {
                        errorDescriptions.append(", ");
                        errorFields.append(", ");
                    }
                    errorDescriptions.append(((Exception)e.getCauses().get(i)).getMessage());
                    errorFields.append(((IValueMeta)e.getFields().get(i)).toStringMeta());
                }
                this.putError(((CsvInputData)this.data).outputRowMeta, e.getRowData(), e.getCauses().size(), errorDescriptions.toString(), errorFields.toString(), "CSVINPUT001");
            }
            throw new HopException(e.getMessage(), (Throwable)e.getCauses().get(0));
        }
        return true;
    }

    public void prepareToRunInParallel() throws HopException {
        try {
            for (String filename : ((CsvInputData)this.data).filenames) {
                long size = HopVfs.getFileObject((String)filename, (IVariables)this.variables).getContent().getSize();
                ((CsvInputData)this.data).fileSizes.add(size);
                ((CsvInputData)this.data).totalFileSize += size;
            }
            ((CsvInputData)this.data).blockToRead = Math.round((double)((CsvInputData)this.data).totalFileSize / (double)((CsvInputData)this.data).totalNumberOfTransforms);
            ((CsvInputData)this.data).startPosition = ((CsvInputData)this.data).blockToRead * (long)((CsvInputData)this.data).transformNumber;
            ((CsvInputData)this.data).endPosition = ((CsvInputData)this.data).startPosition + ((CsvInputData)this.data).blockToRead;
            long totalFileSize = 0L;
            for (int i = 0; i < ((CsvInputData)this.data).fileSizes.size(); ++i) {
                long size = ((CsvInputData)this.data).fileSizes.get(i);
                if (((CsvInputData)this.data).startPosition >= totalFileSize && ((CsvInputData)this.data).startPosition < totalFileSize + size) {
                    ((CsvInputData)this.data).filenr = i;
                    ((CsvInputData)this.data).startFilenr = i;
                    if (((CsvInputData)this.data).startPosition == 0L) {
                        ((CsvInputData)this.data).bytesToSkipInFirstFile = 0L;
                        break;
                    }
                    ((CsvInputData)this.data).bytesToSkipInFirstFile = ((CsvInputData)this.data).startPosition - totalFileSize;
                    break;
                }
                totalFileSize += size;
            }
            if (((CsvInputData)this.data).filenames.length > 0) {
                this.logBasic(BaseMessages.getString(PKG, (String)"CsvInput.Log.ParallelFileNrAndPositionFeedback", (String[])new String[]{((CsvInputData)this.data).filenames[((CsvInputData)this.data).filenr], Long.toString(((CsvInputData)this.data).fileSizes.get(((CsvInputData)this.data).filenr)), Long.toString(((CsvInputData)this.data).bytesToSkipInFirstFile), Long.toString(((CsvInputData)this.data).blockToRead)}));
            }
        }
        catch (Exception e) {
            throw new HopException(BaseMessages.getString(PKG, (String)"CsvInput.Exception.ErrorPreparingParallelRun", (String[])new String[0]), (Throwable)e);
        }
    }

    private void getFilenamesFromPreviousTransforms() throws HopException {
        ArrayList<String> filenames = new ArrayList<String>();
        boolean firstRow = true;
        int index = -1;
        Object[] row = this.getRow();
        while (row != null) {
            if (firstRow) {
                firstRow = false;
                String filenameField = this.resolve(((CsvInputMeta)this.meta).getFilenameField());
                index = this.getInputRowMeta().indexOfValue(filenameField);
                if (index < 0) {
                    throw new HopException(BaseMessages.getString(PKG, (String)"CsvInput.Exception.FilenameFieldNotFound", (String[])new String[]{filenameField}));
                }
            }
            String filename = this.getInputRowMeta().getString(row, index);
            filenames.add(filename);
            row = this.getRow();
        }
        ((CsvInputData)this.data).filenames = filenames.toArray(new String[filenames.size()]);
        this.logBasic(BaseMessages.getString(PKG, (String)"CsvInput.Log.ReadingFromNrFiles", (String[])new String[]{Integer.toString(((CsvInputData)this.data).filenames.length)}));
    }

    public void dispose() {
        try {
            if (((CsvInputData)this.data).fc != null) {
                ((CsvInputData)this.data).fc.close();
            }
        }
        catch (Exception e) {
            this.logError("Error closing file channel", e);
        }
        try {
            if (((CsvInputData)this.data).fis != null) {
                ((CsvInputData)this.data).fis.close();
            }
        }
        catch (Exception e) {
            this.logError("Error closing file input stream", e);
        }
        super.dispose();
    }

    private boolean openNextFile() throws HopException {
        try {
            ((CsvInputData)this.data).closeFile();
            if (((CsvInputData)this.data).filenr >= ((CsvInputData)this.data).filenames.length) {
                return false;
            }
            ((CsvInputData)this.data).fieldsMapping = this.createFieldMapping(((CsvInputData)this.data).filenames[((CsvInputData)this.data).filenr], (CsvInputMeta)this.meta);
            FileObject fileObject = HopVfs.getFileObject((String)((CsvInputData)this.data).filenames[((CsvInputData)this.data).filenr], (IVariables)this.variables);
            if (!(fileObject instanceof LocalFile)) {
                throw new HopException(BaseMessages.getString(PKG, (String)"CsvInput.Log.OnlyLocalFilesAreSupported", (String[])new String[0]));
            }
            if (((CsvInputMeta)this.meta).isLazyConversionActive()) {
                ((CsvInputData)this.data).binaryFilename = ((CsvInputData)this.data).filenames[((CsvInputData)this.data).filenr].getBytes();
            }
            String vfsFilename = HopVfs.getFilename((FileObject)fileObject);
            int bomSize = this.getBOMSize(vfsFilename);
            ((CsvInputData)this.data).fis = new FileInputStream(vfsFilename);
            if (0 != bomSize) {
                ((CsvInputData)this.data).fis.skip(bomSize);
            }
            ((CsvInputData)this.data).fc = ((CsvInputData)this.data).fis.getChannel();
            ((CsvInputData)this.data).bb = ByteBuffer.allocateDirect(((CsvInputData)this.data).preferredBufferSize);
            if (((CsvInputData)this.data).parallel && ((CsvInputData)this.data).bytesToSkipInFirstFile > 0L) {
                ((CsvInputData)this.data).fc.position(((CsvInputData)this.data).bytesToSkipInFirstFile);
                if (this.needToSkipRow()) {
                    while (!((CsvInputData)this.data).newLineFound()) {
                        ((CsvInputData)this.data).moveEndBufferPointer();
                    }
                    ((CsvInputData)this.data).moveEndBufferPointer();
                    if (((CsvInputData)this.data).newLineFound()) {
                        ((CsvInputData)this.data).moveEndBufferPointer();
                    }
                }
                ((CsvInputData)this.data).setStartBuffer(((CsvInputData)this.data).getEndBuffer());
            }
            if (((CsvInputMeta)this.meta).isAddResultFile()) {
                ResultFile resultFile = new ResultFile(0, fileObject, this.getPipelineMeta().getName(), this.toString());
                resultFile.setComment("File was read by a Csv input transform");
                this.addResultFile(resultFile);
            }
            ++((CsvInputData)this.data).filenr;
            if (((CsvInputMeta)this.meta).isHeaderPresent() && (!((CsvInputData)this.data).parallel || ((CsvInputData)this.data).bytesToSkipInFirstFile <= 0L)) {
                this.readOneRow(true, false);
                this.logBasic(BaseMessages.getString(PKG, (String)"CsvInput.Log.HeaderRowSkipped", (String[])new String[]{((CsvInputData)this.data).filenames[((CsvInputData)this.data).filenr - 1]}));
                if (((CsvInputData)this.data).fieldsMapping.size() == 0) {
                    return false;
                }
            }
            ((CsvInputData)this.data).rowNumber = 1L;
            ((CsvInputData)this.data).bytesToSkipInFirstFile = -1L;
            return true;
        }
        catch (HopException e) {
            throw e;
        }
        catch (Exception e) {
            throw new HopException((Throwable)e);
        }
    }

    protected int getBOMSize(String vfsFilename) throws Exception {
        int bomSize = 0;
        try (FileInputStream fis = new FileInputStream(vfsFilename);
             BufferedInputStream bis = new BufferedInputStream(fis);){
            BOMDetector bom = new BOMDetector(bis);
            if (bom.bomExist()) {
                bomSize = bom.getBomSize();
            }
        }
        return bomSize;
    }

    IFieldsMapping createFieldMapping(String fileName, CsvInputMeta csvInputMeta) throws HopException {
        IFieldsMapping mapping = null;
        if (csvInputMeta.isHeaderPresent()) {
            String[] fieldNames = this.readFieldNamesFromFile(fileName, csvInputMeta);
            mapping = NamedFieldsMapping.mapping(fieldNames, CsvInput.fieldNames(csvInputMeta));
        } else {
            int fieldsCount = csvInputMeta.getInputFields() == null ? 0 : csvInputMeta.getInputFields().length;
            mapping = UnnamedFieldsMapping.mapping(fieldsCount);
        }
        return mapping;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    String[] readFieldNamesFromFile(String fileName, CsvInputMeta csvInputMeta) throws HopException {
        String delimiter = this.resolve(csvInputMeta.getDelimiter());
        String enclosure = this.resolve(csvInputMeta.getEnclosure());
        String realEncoding = this.resolve(csvInputMeta.getEncoding());
        try (FileObject fileObject = HopVfs.getFileObject((String)fileName, (IVariables)this.variables);){
            String[] stringArray;
            try (BOMInputStream inputStream = new BOMInputStream(HopVfs.getInputStream((FileObject)fileObject), new ByteOrderMark[]{ByteOrderMark.UTF_8, ByteOrderMark.UTF_16LE, ByteOrderMark.UTF_16BE});){
                InputStreamReader reader = null;
                reader = Utils.isEmpty((CharSequence)realEncoding) ? new InputStreamReader((InputStream)inputStream) : new InputStreamReader((InputStream)inputStream, realEncoding);
                EncodingType encodingType = EncodingType.guessEncodingType((String)reader.getEncoding());
                String line = TextFileInput.getLine(this.getLogChannel(), reader, encodingType, 1, new StringBuilder(1000));
                String[] fieldNames = TextFileLineUtil.guessStringsFromLine((ILogChannel)this.getLogChannel(), (String)line, (String)delimiter, (String)enclosure, (String)csvInputMeta.getEscapeCharacter());
                if (!Utils.isEmpty((CharSequence)csvInputMeta.getEnclosure())) {
                    CsvInput.removeEnclosure(fieldNames, csvInputMeta.getEnclosure());
                }
                CsvInput.trimFieldNames(fieldNames);
                stringArray = fieldNames;
            }
            return stringArray;
        }
        catch (IOException e) {
            throw new HopFileException(BaseMessages.getString(PKG, (String)"CsvInput.Exception.CreateFieldMappingError", (String[])new String[0]), (Throwable)e);
        }
    }

    static String[] fieldNames(CsvInputMeta csvInputMeta) {
        TextFileInputField[] fields = csvInputMeta.getInputFields();
        String[] fieldNames = new String[fields.length];
        for (int i = 0; i < fields.length; ++i) {
            fieldNames[i] = fields[i].getName();
        }
        return fieldNames;
    }

    static void trimFieldNames(String[] strings) {
        if (strings != null) {
            for (int i = 0; i < strings.length; ++i) {
                strings[i] = strings[i].trim();
            }
        }
    }

    static void removeEnclosure(String[] fields, String enclosure) {
        if (fields != null) {
            for (int i = 0; i < fields.length; ++i) {
                if (!fields[i].startsWith(enclosure) || !fields[i].endsWith(enclosure) || fields[i].length() <= 1) continue;
                fields[i] = fields[i].substring(1, fields[i].length() - 1);
            }
        }
    }

    private boolean needToSkipRow() {
        try {
            ((CsvInputData)this.data).fc.position(((CsvInputData)this.data).fc.position() - 1L);
            ((CsvInputData)this.data).resizeBufferIfNeeded();
            if (((CsvInputData)this.data).newLineFound()) {
                ((CsvInputData)this.data).moveEndBufferPointer(false);
                boolean bl = ((CsvInputData)this.data).newLineFound();
                return bl;
            }
            ((CsvInputData)this.data).moveEndBufferPointer(false);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                ((CsvInputData)this.data).fc.position(((CsvInputData)this.data).fc.position() + 1L);
            }
            catch (IOException iOException) {}
        }
        return true;
    }

    private Object[] readOneRow(boolean skipRow, boolean ignoreEnclosures) throws HopException {
        try {
            Object[] outputRowData = RowDataUtil.allocateRowData((int)((CsvInputData)this.data).outputRowMeta.size());
            int outputIndex = 0;
            boolean newLineFound = false;
            boolean endOfBuffer = false;
            ArrayList<HopValueException> conversionExceptions = null;
            ArrayList<IValueMeta> exceptionFields = null;
            while (!newLineFound && outputIndex < ((CsvInputMeta)this.meta).getInputFields().length) {
                int actualFieldIndex;
                if (((CsvInputData)this.data).resizeBufferIfNeeded()) {
                    if (outputRowData != null && outputIndex > 0) {
                        if (((CsvInputMeta)this.meta).isIncludingFilename() && !Utils.isEmpty((CharSequence)((CsvInputMeta)this.meta).getFilenameField())) {
                            outputRowData[((CsvInputData)this.data).filenameFieldIndex] = ((CsvInputMeta)this.meta).isLazyConversionActive() ? (Object)((CsvInputData)this.data).binaryFilename : ((CsvInputData)this.data).filenames[((CsvInputData)this.data).filenr - 1];
                        }
                        if (((CsvInputData)this.data).isAddingRowNumber) {
                            outputRowData[((CsvInputData)this.data).rownumFieldIndex] = ((CsvInputData)this.data).rowNumber++;
                        }
                        this.incrementLinesInput();
                        return outputRowData;
                    }
                    return null;
                }
                boolean delimiterFound = false;
                boolean enclosureFound = false;
                boolean doubleLineEnd = false;
                int escapedEnclosureFound = 0;
                boolean ignoreEnclosuresInField = ignoreEnclosures;
                while (!(delimiterFound || newLineFound || endOfBuffer)) {
                    if (((CsvInputData)this.data).delimiterFound()) {
                        delimiterFound = true;
                        continue;
                    }
                    if ((!((CsvInputMeta)this.meta).isNewlinePossibleInFields() || outputIndex == ((CsvInputData)this.data).fieldsMapping.size() - 1) && ((CsvInputData)this.data).newLineFound()) {
                        newLineFound = true;
                        for (int i = 0; i < ((CsvInputData)this.data).encodingType.getLength(); ++i) {
                            ((CsvInputData)this.data).moveEndBufferPointer();
                        }
                        if (!((CsvInputData)this.data).newLineFound()) continue;
                        doubleLineEnd = true;
                        continue;
                    }
                    if (((CsvInputData)this.data).enclosureFound() && !ignoreEnclosuresInField) {
                        int enclosurePosition = ((CsvInputData)this.data).getEndBuffer();
                        int fieldFirstBytePosition = ((CsvInputData)this.data).getStartBuffer();
                        if (fieldFirstBytePosition == enclosurePosition) {
                            boolean keepGoing;
                            enclosureFound = true;
                            do {
                                if (((CsvInputData)this.data).moveEndBufferPointer()) {
                                    enclosureFound = false;
                                    break;
                                }
                                boolean bl = keepGoing = !((CsvInputData)this.data).enclosureFound();
                                if (keepGoing) continue;
                                if (!((CsvInputData)this.data).endOfBuffer() && ((CsvInputData)this.data).moveEndBufferPointer()) break;
                                if (((CsvInputData)this.data).enclosure.length > 1) {
                                    ((CsvInputData)this.data).moveEndBufferPointer();
                                }
                                if (!(keepGoing = ((CsvInputData)this.data).enclosureFound())) continue;
                                ++escapedEnclosureFound;
                            } while (keepGoing);
                            if (!((CsvInputData)this.data).endOfBuffer()) continue;
                            endOfBuffer = true;
                            break;
                        }
                        ignoreEnclosuresInField = true;
                        continue;
                    }
                    if (!((CsvInputData)this.data).moveEndBufferPointer()) continue;
                    endOfBuffer = true;
                    break;
                }
                byte[] field = ((CsvInputData)this.data).getField(delimiterFound, enclosureFound, newLineFound, endOfBuffer);
                if (escapedEnclosureFound > 0) {
                    if (this.isRowLevel()) {
                        this.logRowlevel("Escaped enclosures found in " + new String(field));
                    }
                    field = ((CsvInputData)this.data).removeEscapedEnclosures(field, escapedEnclosureFound);
                }
                if ((actualFieldIndex = outputIndex++) != -1) {
                    if (!skipRow) {
                        if (((CsvInputMeta)this.meta).isLazyConversionActive()) {
                            outputRowData[actualFieldIndex] = field;
                        } else {
                            IValueMeta sourceValueMeta = ((CsvInputData)this.data).convertRowMeta.getValueMeta(actualFieldIndex);
                            try {
                                outputRowData[actualFieldIndex] = sourceValueMeta.convertBinaryStringToNativeType(field);
                            }
                            catch (HopValueException e) {
                                outputRowData[actualFieldIndex] = null;
                                if (conversionExceptions == null) {
                                    conversionExceptions = new ArrayList<HopValueException>();
                                    exceptionFields = new ArrayList<IValueMeta>();
                                }
                                conversionExceptions.add(e);
                                exceptionFields.add(sourceValueMeta);
                            }
                        }
                    } else {
                        outputRowData[actualFieldIndex] = null;
                    }
                }
                if (!newLineFound && outputIndex < ((CsvInputMeta)this.meta).getInputFields().length || newLineFound && doubleLineEnd) {
                    for (int i = 0; !((CsvInputData)this.data).newLineFound() && i < ((CsvInputData)this.data).delimiter.length; ++i) {
                        ((CsvInputData)this.data).moveEndBufferPointer();
                    }
                    if (((CsvInputData)this.data).isCarriageReturn() || doubleLineEnd) {
                        ((CsvInputData)this.data).moveEndBufferPointerXTimes(((CsvInputData)this.data).encodingType.getLength());
                    }
                }
                ((CsvInputData)this.data).setStartBuffer(((CsvInputData)this.data).getEndBuffer());
            }
            if (!newLineFound && !((CsvInputData)this.data).resizeBufferIfNeeded()) {
                do {
                    ((CsvInputData)this.data).moveEndBufferPointer();
                } while (!((CsvInputData)this.data).resizeBufferIfNeeded() && !((CsvInputData)this.data).newLineFound());
                if (!((CsvInputData)this.data).resizeBufferIfNeeded()) {
                    while (((CsvInputData)this.data).newLineFound()) {
                        ((CsvInputData)this.data).moveEndBufferPointer();
                        if (!((CsvInputData)this.data).resizeBufferIfNeeded()) continue;
                    }
                }
                ((CsvInputData)this.data).setStartBuffer(((CsvInputData)this.data).getEndBuffer());
            }
            if (((CsvInputMeta)this.meta).isIncludingFilename() && !Utils.isEmpty((CharSequence)((CsvInputMeta)this.meta).getFilenameField())) {
                outputRowData[((CsvInputData)this.data).filenameFieldIndex] = ((CsvInputMeta)this.meta).isLazyConversionActive() ? (Object)((CsvInputData)this.data).binaryFilename : ((CsvInputData)this.data).filenames[((CsvInputData)this.data).filenr - 1];
            }
            if (((CsvInputData)this.data).isAddingRowNumber) {
                outputRowData[((CsvInputData)this.data).rownumFieldIndex] = ((CsvInputData)this.data).rowNumber++;
            }
            if (!ignoreEnclosures) {
                this.incrementLinesInput();
            }
            if (conversionExceptions != null && !conversionExceptions.isEmpty()) {
                throw new HopConversionException("There were " + conversionExceptions.size() + " conversion errors on line " + this.getLinesInput(), (List)conversionExceptions, exceptionFields, outputRowData);
            }
            return outputRowData;
        }
        catch (HopConversionException e) {
            throw e;
        }
        catch (IOException e) {
            throw new HopFileException("Exception reading line using NIO", (Throwable)e);
        }
    }

    public boolean init() {
        if (super.init()) {
            String realEncoding = this.resolve(((CsvInputMeta)this.meta).getEncoding());
            ((CsvInputData)this.data).preferredBufferSize = Integer.parseInt(this.resolve(((CsvInputMeta)this.meta).getBufferSize()));
            if (this.getPipelineMeta().findPreviousTransforms(this.getTransformMeta()).isEmpty()) {
                String filename = this.resolve(((CsvInputMeta)this.meta).getFilename());
                if (Utils.isEmpty((CharSequence)filename)) {
                    this.logError(BaseMessages.getString(PKG, (String)"CsvInput.MissingFilename.Message", (String[])new String[0]));
                    return false;
                }
                ((CsvInputData)this.data).filenames = new String[]{filename};
            } else {
                ((CsvInputData)this.data).filenames = null;
                ((CsvInputData)this.data).filenr = 0;
            }
            ((CsvInputData)this.data).totalBytesRead = 0L;
            ((CsvInputData)this.data).encodingType = EncodingType.guessEncodingType((String)realEncoding);
            try {
                ((CsvInputData)this.data).delimiter = ((CsvInputData)this.data).encodingType.getBytes(this.resolve(((CsvInputMeta)this.meta).getDelimiter()), realEncoding);
                ((CsvInputData)this.data).enclosure = (byte[])(Utils.isEmpty((CharSequence)((CsvInputMeta)this.meta).getEnclosure()) ? null : ((CsvInputData)this.data).encodingType.getBytes(this.resolve(((CsvInputMeta)this.meta).getEnclosure()), realEncoding));
            }
            catch (UnsupportedEncodingException e) {
                this.logError(BaseMessages.getString(PKG, (String)"CsvInput.BadEncoding.Message", (String[])new String[0]), e);
                return false;
            }
            ((CsvInputData)this.data).isAddingRowNumber = !Utils.isEmpty((CharSequence)((CsvInputMeta)this.meta).getRowNumField());
            ((CsvInputData)this.data).stopReading = false;
            if (((CsvInputMeta)this.meta).isRunningInParallel()) {
                ((CsvInputData)this.data).transformNumber = this.getCopyNr();
                ((CsvInputData)this.data).totalNumberOfTransforms = this.getTransformMeta().getCopies((IVariables)this);
                ((CsvInputData)this.data).fileSizes = new ArrayList<Long>();
                ((CsvInputData)this.data).totalFileSize = 0L;
            }
            ((CsvInputData)this.data).delimiterMatcher = ((CsvInputData)this.data).delimiter.length == 1 ? new SingleBytePatternMatcher() : new MultiBytePatternMatcher();
            ((CsvInputData)this.data).enclosureMatcher = ((CsvInputData)this.data).enclosure == null ? new EmptyPatternMatcher() : (((CsvInputData)this.data).enclosure.length == 1 ? new SingleBytePatternMatcher() : new MultiBytePatternMatcher());
            switch (((CsvInputData)this.data).encodingType) {
                case DOUBLE_BIG_ENDIAN: {
                    ((CsvInputData)this.data).crLfMatcher = new MultiByteBigCrLfMatcher();
                    break;
                }
                case DOUBLE_LITTLE_ENDIAN: {
                    ((CsvInputData)this.data).crLfMatcher = new MultiByteLittleCrLfMatcher();
                    break;
                }
                default: {
                    ((CsvInputData)this.data).crLfMatcher = new SingleByteCrLfMatcher();
                }
            }
            return true;
        }
        return false;
    }
}

