/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.core.gui;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.hop.base.AbstractMeta;
import org.apache.hop.core.Const;
import org.apache.hop.core.util.EnvUtil;
import org.apache.hop.workflow.ActionResult;
import org.apache.hop.workflow.WorkflowMeta;
import org.apache.hop.workflow.action.ActionMeta;

public class WorkflowTracker<T extends WorkflowMeta> {
    private LinkedList<WorkflowTracker> workflowTrackers;
    private ActionResult result;
    private WorkflowTracker parentWorkflowTracker;
    private String workflowName;
    private String workflowFilename;
    private int maxChildren;
    private final ReentrantReadWriteLock lock;

    public WorkflowTracker(T workflowMeta) {
        this(workflowMeta, Const.toInt((String)EnvUtil.getSystemProperty((String)"HOP_MAX_WORKFLOW_TRACKER_SIZE"), (int)5000));
    }

    public WorkflowTracker(T workflowMeta, int maxChildren) {
        if (workflowMeta != null) {
            this.workflowName = ((WorkflowMeta)workflowMeta).getName();
            this.workflowFilename = ((AbstractMeta)workflowMeta).getFilename();
        }
        this.workflowTrackers = new LinkedList();
        this.maxChildren = maxChildren;
        this.lock = new ReentrantReadWriteLock();
    }

    public WorkflowTracker(T workflowMeta, ActionResult result) {
        this(workflowMeta);
        this.result = result;
    }

    public WorkflowTracker(T workflowMeta, int maxChildren, ActionResult result) {
        this(workflowMeta, maxChildren);
        this.result = result;
    }

    public void addWorkflowTracker(WorkflowTracker workflowTracker) {
        this.lock.writeLock().lock();
        try {
            this.workflowTrackers.add(workflowTracker);
            while (this.workflowTrackers.size() > this.maxChildren) {
                this.workflowTrackers.removeFirst();
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public WorkflowTracker getWorkflowTracker(int i) {
        this.lock.readLock().lock();
        try {
            WorkflowTracker workflowTracker = this.workflowTrackers.get(i);
            return workflowTracker;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public int nrWorkflowTrackers() {
        this.lock.readLock().lock();
        try {
            int n = this.workflowTrackers.size();
            return n;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public List<WorkflowTracker> getWorkflowTrackers() {
        this.lock.readLock().lock();
        try {
            ArrayList<WorkflowTracker> arrayList = new ArrayList<WorkflowTracker>(this.workflowTrackers);
            return arrayList;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public void setWorkflowTrackers(List<WorkflowTracker> workflowTrackers) {
        this.lock.writeLock().lock();
        try {
            this.workflowTrackers.clear();
            this.workflowTrackers.addAll(workflowTrackers);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public ActionResult getActionResult() {
        return this.result;
    }

    public void setActionResult(ActionResult result) {
        this.result = result;
    }

    public void clear() {
        this.lock.writeLock().lock();
        try {
            this.workflowTrackers.clear();
            this.result = null;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WorkflowTracker findWorkflowTracker(ActionMeta actionMeta) {
        if (actionMeta.getName() == null) {
            return null;
        }
        this.lock.readLock().lock();
        try {
            ListIterator<WorkflowTracker> it = this.workflowTrackers.listIterator(this.workflowTrackers.size());
            while (it.hasPrevious()) {
                WorkflowTracker tracker = it.previous();
                ActionResult result = tracker.getActionResult();
                if (result == null || !actionMeta.getName().equals(result.getActionName())) continue;
                WorkflowTracker workflowTracker = tracker;
                return workflowTracker;
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        return null;
    }

    public WorkflowTracker getParentWorkflowTracker() {
        return this.parentWorkflowTracker;
    }

    public void setParentWorkflowTracker(WorkflowTracker parentWorkflowTracker) {
        this.parentWorkflowTracker = parentWorkflowTracker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTotalNumberOfItems() {
        this.lock.readLock().lock();
        try {
            int total = 1;
            for (WorkflowTracker workflowTracker : this.workflowTrackers) {
                total += workflowTracker.getTotalNumberOfItems();
            }
            int n = total;
            return n;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public String getWorfkflowFilename() {
        return this.workflowFilename;
    }

    public void setWorkflowFilename(String workflowFilename) {
        this.workflowFilename = workflowFilename;
    }

    public String getWorkflowName() {
        return this.workflowName;
    }

    public void setWorkflowName(String workflowName) {
        this.workflowName = workflowName;
    }

    public int getMaxChildren() {
        return this.maxChildren;
    }

    public void setMaxChildren(int maxChildren) {
        this.maxChildren = maxChildren;
    }
}

