/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io;

import com.google.auto.value.AutoValue;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.io.AutoValue_TextIO_Read;
import org.apache.beam.sdk.io.AutoValue_TextIO_ReadAll;
import org.apache.beam.sdk.io.AutoValue_TextIO_ReadFiles;
import org.apache.beam.sdk.io.AutoValue_TextIO_Sink;
import org.apache.beam.sdk.io.AutoValue_TextIO_TypedWrite;
import org.apache.beam.sdk.io.CompressedSource;
import org.apache.beam.sdk.io.Compression;
import org.apache.beam.sdk.io.DefaultFilenamePolicy;
import org.apache.beam.sdk.io.DynamicFileDestinations;
import org.apache.beam.sdk.io.FileBasedSink;
import org.apache.beam.sdk.io.FileBasedSource;
import org.apache.beam.sdk.io.FileIO;
import org.apache.beam.sdk.io.ReadAllViaFileBasedSource;
import org.apache.beam.sdk.io.TextSink;
import org.apache.beam.sdk.io.TextSource;
import org.apache.beam.sdk.io.WriteFiles;
import org.apache.beam.sdk.io.WriteFilesResult;
import org.apache.beam.sdk.io.fs.EmptyMatchTreatment;
import org.apache.beam.sdk.io.fs.ResourceId;
import org.apache.beam.sdk.options.ValueProvider;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.SerializableFunctions;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.sdk.transforms.errorhandling.BadRecord;
import org.apache.beam.sdk.transforms.errorhandling.ErrorHandler;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PDone;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Predicate;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Predicates;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Iterables;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Lists;
import org.apache.commons.compress.utils.CharsetNames;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Duration;

public class TextIO {
    private static final @UnknownKeyFor @NonNull @Initialized long DEFAULT_BUNDLE_SIZE_BYTES = 0x4000000L;

    public static @UnknownKeyFor @NonNull @Initialized Read read() {
        return new AutoValue_TextIO_Read.Builder().setCompression(Compression.AUTO).setHintMatchesManyFiles(false).setSkipHeaderLines(0).setMatchConfiguration(FileIO.MatchConfiguration.create(EmptyMatchTreatment.DISALLOW)).build();
    }

    @Deprecated
    public static @UnknownKeyFor @NonNull @Initialized ReadAll readAll() {
        return new AutoValue_TextIO_ReadAll.Builder().setCompression(Compression.AUTO).setSkipHeaderLines(0).setMatchConfiguration(FileIO.MatchConfiguration.create(EmptyMatchTreatment.ALLOW_IF_WILDCARD)).build();
    }

    public static @UnknownKeyFor @NonNull @Initialized ReadFiles readFiles() {
        return new AutoValue_TextIO_ReadFiles.Builder().setDesiredBundleSizeBytes(0x4000000L).setSkipHeaderLines(0).build();
    }

    public static @UnknownKeyFor @NonNull @Initialized Write write() {
        return new Write();
    }

    public static <UserT> @UnknownKeyFor @NonNull @Initialized TypedWrite<UserT, @UnknownKeyFor @Nullable @Initialized Void> writeCustomType() {
        return new AutoValue_TextIO_TypedWrite.Builder().setFilenamePrefix(null).setTempDirectory(null).setShardTemplate(null).setFilenameSuffix(null).setFilenamePolicy(null).setDynamicDestinations(null).setDelimiter(new char[]{'\n'}).setWritableByteChannelFactory(FileBasedSink.CompressionType.UNCOMPRESSED).setWindowedWrites(false).setNoSpilling(false).setSkipIfEmpty(false).setAutoSharding(false).build();
    }

    public static @UnknownKeyFor @NonNull @Initialized Sink sink() {
        return new AutoValue_TextIO_Sink.Builder().build();
    }

    private TextIO() {
    }

    @AutoValue
    public static abstract class Sink
    implements FileIO.Sink<String> {
        private transient @Nullable @UnknownKeyFor @Initialized PrintWriter writer;

        abstract @Nullable @UnknownKeyFor @Initialized String getHeader();

        abstract @Nullable @UnknownKeyFor @Initialized String getFooter();

        abstract @UnknownKeyFor @NonNull @Initialized Builder toBuilder();

        public @UnknownKeyFor @NonNull @Initialized Sink withHeader(@UnknownKeyFor @NonNull @Initialized String header) {
            Preconditions.checkArgument((header != null ? 1 : 0) != 0, (Object)"header can not be null");
            return this.toBuilder().setHeader(header).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Sink withFooter(@UnknownKeyFor @NonNull @Initialized String footer) {
            Preconditions.checkArgument((footer != null ? 1 : 0) != 0, (Object)"footer can not be null");
            return this.toBuilder().setFooter(footer).build();
        }

        @Override
        public void open(@UnknownKeyFor @NonNull @Initialized WritableByteChannel channel) throws @UnknownKeyFor @NonNull @Initialized IOException {
            this.writer = new PrintWriter(new BufferedWriter(new OutputStreamWriter(Channels.newOutputStream(channel), CharsetNames.UTF_8)));
            if (this.getHeader() != null) {
                this.writer.println(this.getHeader());
            }
        }

        @Override
        public void write(@UnknownKeyFor @NonNull @Initialized String element) throws @UnknownKeyFor @NonNull @Initialized IOException {
            this.writer.println(element);
        }

        @Override
        public void flush() throws @UnknownKeyFor @NonNull @Initialized IOException {
            if (this.getFooter() != null) {
                this.writer.println(this.getFooter());
            }
            this.writer.flush();
        }

        @AutoValue.Builder
        static abstract class Builder {
            Builder() {
            }

            abstract @UnknownKeyFor @NonNull @Initialized Builder setHeader(@UnknownKeyFor @NonNull @Initialized String var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setFooter(@UnknownKeyFor @NonNull @Initialized String var1);

            abstract @UnknownKeyFor @NonNull @Initialized Sink build();
        }
    }

    @Deprecated
    public static enum CompressionType {
        AUTO(Compression.AUTO),
        UNCOMPRESSED(Compression.UNCOMPRESSED),
        GZIP(Compression.GZIP),
        BZIP2(Compression.BZIP2),
        ZIP(Compression.ZIP),
        ZSTD(Compression.ZSTD),
        DEFLATE(Compression.DEFLATE);

        private final @UnknownKeyFor @NonNull @Initialized Compression canonical;

        private CompressionType(Compression canonical) {
            this.canonical = canonical;
        }

        public @UnknownKeyFor @NonNull @Initialized boolean matches(@UnknownKeyFor @NonNull @Initialized String filename) {
            return this.canonical.matches(filename);
        }
    }

    public static class Write
    extends PTransform<PCollection<String>, PDone> {
        @VisibleForTesting
        /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized TypedWrite<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> inner;

        Write() {
            this(TextIO.writeCustomType());
        }

        Write(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized TypedWrite<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> inner) {
            this.inner = inner;
        }

        public @UnknownKeyFor @NonNull @Initialized Write to(@UnknownKeyFor @NonNull @Initialized String filenamePrefix) {
            return new Write(this.inner.to(filenamePrefix).withFormatFunction(SerializableFunctions.identity()));
        }

        public @UnknownKeyFor @NonNull @Initialized Write to(@UnknownKeyFor @NonNull @Initialized ResourceId filenamePrefix) {
            return new Write(this.inner.to(filenamePrefix).withFormatFunction(SerializableFunctions.identity()));
        }

        public @UnknownKeyFor @NonNull @Initialized Write to(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> outputPrefix) {
            return new Write(this.inner.to(outputPrefix).withFormatFunction(SerializableFunctions.identity()));
        }

        public @UnknownKeyFor @NonNull @Initialized Write toResource(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized ResourceId> filenamePrefix) {
            return new Write(this.inner.toResource(filenamePrefix).withFormatFunction(SerializableFunctions.identity()));
        }

        public @UnknownKeyFor @NonNull @Initialized Write to(@UnknownKeyFor @NonNull @Initialized FileBasedSink.FilenamePolicy filenamePolicy) {
            return new Write(this.inner.to(filenamePolicy).withFormatFunction(SerializableFunctions.identity()));
        }

        @Deprecated
        public @UnknownKeyFor @NonNull @Initialized Write to(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized FileBasedSink.DynamicDestinations<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @NonNull @Initialized String> dynamicDestinations) {
            return new Write(this.inner.to(dynamicDestinations).withFormatFunction(null));
        }

        @Deprecated
        public @UnknownKeyFor @NonNull @Initialized Write to(@UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized DefaultFilenamePolicy.Params> destinationFunction, @UnknownKeyFor @NonNull @Initialized DefaultFilenamePolicy.Params emptyDestination) {
            return new Write(this.inner.to(destinationFunction, emptyDestination).withFormatFunction(SerializableFunctions.identity()));
        }

        public @UnknownKeyFor @NonNull @Initialized Write withTempDirectory(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized ResourceId> tempDirectory) {
            return new Write(this.inner.withTempDirectory(tempDirectory));
        }

        public @UnknownKeyFor @NonNull @Initialized Write withTempDirectory(@UnknownKeyFor @NonNull @Initialized ResourceId tempDirectory) {
            return new Write(this.inner.withTempDirectory(tempDirectory));
        }

        public @UnknownKeyFor @NonNull @Initialized Write withShardNameTemplate(@UnknownKeyFor @NonNull @Initialized String shardTemplate) {
            return new Write(this.inner.withShardNameTemplate(shardTemplate));
        }

        public @UnknownKeyFor @NonNull @Initialized Write withSuffix(@UnknownKeyFor @NonNull @Initialized String filenameSuffix) {
            return new Write(this.inner.withSuffix(filenameSuffix));
        }

        public @UnknownKeyFor @NonNull @Initialized Write withNumShards(@UnknownKeyFor @NonNull @Initialized int numShards) {
            return new Write(this.inner.withNumShards(numShards));
        }

        public @UnknownKeyFor @NonNull @Initialized Write withNumShards(@Nullable @UnknownKeyFor @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized Integer> numShards) {
            return new Write(this.inner.withNumShards(numShards));
        }

        public @UnknownKeyFor @NonNull @Initialized Write withoutSharding() {
            return new Write(this.inner.withoutSharding());
        }

        public @UnknownKeyFor @NonNull @Initialized Write withDelimiter(@UnknownKeyFor @NonNull @Initialized char @UnknownKeyFor @NonNull @Initialized [] delimiter) {
            return new Write(this.inner.withDelimiter(delimiter));
        }

        public @UnknownKeyFor @NonNull @Initialized Write withHeader(@Nullable @UnknownKeyFor @Initialized String header) {
            return new Write(this.inner.withHeader(header));
        }

        public @UnknownKeyFor @NonNull @Initialized Write withFooter(@Nullable @UnknownKeyFor @Initialized String footer) {
            return new Write(this.inner.withFooter(footer));
        }

        public @UnknownKeyFor @NonNull @Initialized Write withWritableByteChannelFactory(@UnknownKeyFor @NonNull @Initialized FileBasedSink.WritableByteChannelFactory writableByteChannelFactory) {
            return new Write(this.inner.withWritableByteChannelFactory(writableByteChannelFactory));
        }

        public @UnknownKeyFor @NonNull @Initialized Write withCompression(@UnknownKeyFor @NonNull @Initialized Compression compression) {
            return new Write(this.inner.withCompression(compression));
        }

        public @UnknownKeyFor @NonNull @Initialized Write withWindowedWrites() {
            return new Write(this.inner.withWindowedWrites());
        }

        public @UnknownKeyFor @NonNull @Initialized Write withAutoSharding() {
            return new Write(this.inner.withAutoSharding());
        }

        public @UnknownKeyFor @NonNull @Initialized Write withNoSpilling() {
            return new Write(this.inner.withNoSpilling());
        }

        public @UnknownKeyFor @NonNull @Initialized Write withBatchSize(@Nullable @UnknownKeyFor @Initialized Integer batchSize) {
            return new Write(this.inner.withBatchSize(batchSize));
        }

        public @UnknownKeyFor @NonNull @Initialized Write withBatchSizeBytes(@Nullable @UnknownKeyFor @Initialized Integer batchSizeBytes) {
            return new Write(this.inner.withBatchSizeBytes(batchSizeBytes));
        }

        public @UnknownKeyFor @NonNull @Initialized Write withBatchMaxBufferingDuration(@Nullable @UnknownKeyFor @Initialized Duration batchMaxBufferingDuration) {
            return new Write(this.inner.withBatchMaxBufferingDuration(batchMaxBufferingDuration));
        }

        public <DestinationT> @UnknownKeyFor @NonNull @Initialized TypedWrite<@UnknownKeyFor @NonNull @Initialized String, DestinationT> withOutputFilenames() {
            return this.inner;
        }

        @Override
        public void populateDisplayData(@UnknownKeyFor @NonNull @Initialized DisplayData.Builder builder) {
            this.inner.populateDisplayData(builder);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized PDone expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized String> input) {
            this.inner.expand(input);
            return PDone.in(input.getPipeline());
        }
    }

    @AutoValue
    public static abstract class TypedWrite<@UnknownKeyFor UserT, @UnknownKeyFor DestinationT>
    extends PTransform<PCollection<UserT>, WriteFilesResult<DestinationT>> {
        abstract @Nullable @UnknownKeyFor @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized ResourceId> getFilenamePrefix();

        abstract @Nullable @UnknownKeyFor @Initialized String getFilenameSuffix();

        abstract @Nullable @UnknownKeyFor @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized ResourceId> getTempDirectory();

        abstract @UnknownKeyFor @NonNull @Initialized char @UnknownKeyFor @NonNull @Initialized [] getDelimiter();

        abstract @Nullable @UnknownKeyFor @Initialized String getHeader();

        abstract @Nullable @UnknownKeyFor @Initialized String getFooter();

        abstract @Nullable @UnknownKeyFor @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized Integer> getNumShards();

        abstract @Nullable @UnknownKeyFor @Initialized String getShardTemplate();

        abstract @Nullable @UnknownKeyFor @Initialized FileBasedSink.FilenamePolicy getFilenamePolicy();

        abstract @Nullable @UnknownKeyFor @Initialized FileBasedSink.DynamicDestinations<UserT, DestinationT, @UnknownKeyFor @NonNull @Initialized String> getDynamicDestinations();

        abstract @Nullable @UnknownKeyFor @Initialized SerializableFunction<UserT, @UnknownKeyFor @NonNull @Initialized DefaultFilenamePolicy.Params> getDestinationFunction();

        abstract @Nullable @UnknownKeyFor @Initialized DefaultFilenamePolicy.Params getEmptyDestination();

        abstract @Nullable @UnknownKeyFor @Initialized SerializableFunction<UserT, @UnknownKeyFor @NonNull @Initialized String> getFormatFunction();

        abstract @Nullable @UnknownKeyFor @Initialized Integer getBatchSize();

        abstract @Nullable @UnknownKeyFor @Initialized Integer getBatchSizeBytes();

        abstract @Nullable @UnknownKeyFor @Initialized Duration getBatchMaxBufferingDuration();

        abstract @UnknownKeyFor @NonNull @Initialized boolean getWindowedWrites();

        abstract @UnknownKeyFor @NonNull @Initialized boolean getAutoSharding();

        abstract @UnknownKeyFor @NonNull @Initialized boolean getNoSpilling();

        abstract @UnknownKeyFor @NonNull @Initialized boolean getSkipIfEmpty();

        abstract @UnknownKeyFor @NonNull @Initialized FileBasedSink.WritableByteChannelFactory getWritableByteChannelFactory();

        abstract /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @Nullable @UnknownKeyFor @Initialized ErrorHandler<@UnknownKeyFor @NonNull @Initialized BadRecord, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> getBadRecordErrorHandler();

        abstract @UnknownKeyFor @NonNull @Initialized Builder<UserT, DestinationT> toBuilder();

        public @UnknownKeyFor @NonNull @Initialized TypedWrite<UserT, DestinationT> to(@UnknownKeyFor @NonNull @Initialized String filenamePrefix) {
            return this.to(FileBasedSink.convertToFileResourceIfPossible(filenamePrefix));
        }

        public @UnknownKeyFor @NonNull @Initialized TypedWrite<UserT, DestinationT> to(@UnknownKeyFor @NonNull @Initialized ResourceId filenamePrefix) {
            return this.toResource(ValueProvider.StaticValueProvider.of(filenamePrefix));
        }

        public @UnknownKeyFor @NonNull @Initialized TypedWrite<UserT, DestinationT> to(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> outputPrefix) {
            return this.toResource(ValueProvider.NestedValueProvider.of(outputPrefix, FileBasedSink::convertToFileResourceIfPossible));
        }

        public @UnknownKeyFor @NonNull @Initialized TypedWrite<UserT, DestinationT> to(@UnknownKeyFor @NonNull @Initialized FileBasedSink.FilenamePolicy filenamePolicy) {
            return this.toBuilder().setFilenamePolicy(filenamePolicy).build();
        }

        @Deprecated
        public <NewDestinationT> @UnknownKeyFor @NonNull @Initialized TypedWrite<UserT, NewDestinationT> to(@UnknownKeyFor @NonNull @Initialized FileBasedSink.DynamicDestinations<UserT, NewDestinationT, @UnknownKeyFor @NonNull @Initialized String> dynamicDestinations) {
            return this.toBuilder().setDynamicDestinations(dynamicDestinations).build();
        }

        @Deprecated
        public @UnknownKeyFor @NonNull @Initialized TypedWrite<UserT, @UnknownKeyFor @NonNull @Initialized DefaultFilenamePolicy.Params> to(@UnknownKeyFor @NonNull @Initialized SerializableFunction<UserT, @UnknownKeyFor @NonNull @Initialized DefaultFilenamePolicy.Params> destinationFunction, @UnknownKeyFor @NonNull @Initialized DefaultFilenamePolicy.Params emptyDestination) {
            return this.toBuilder().setDestinationFunction(destinationFunction).setEmptyDestination(emptyDestination).build();
        }

        public @UnknownKeyFor @NonNull @Initialized TypedWrite<UserT, DestinationT> toResource(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized ResourceId> filenamePrefix) {
            return this.toBuilder().setFilenamePrefix(filenamePrefix).build();
        }

        @Deprecated
        public @UnknownKeyFor @NonNull @Initialized TypedWrite<UserT, DestinationT> withFormatFunction(@Nullable @UnknownKeyFor @Initialized SerializableFunction<UserT, @UnknownKeyFor @NonNull @Initialized String> formatFunction) {
            return this.toBuilder().setFormatFunction(formatFunction).build();
        }

        public @UnknownKeyFor @NonNull @Initialized TypedWrite<UserT, DestinationT> withBatchSize(@Nullable @UnknownKeyFor @Initialized Integer batchSize) {
            return this.toBuilder().setBatchSize(batchSize).build();
        }

        public @UnknownKeyFor @NonNull @Initialized TypedWrite<UserT, DestinationT> withBatchSizeBytes(@Nullable @UnknownKeyFor @Initialized Integer batchSizeBytes) {
            return this.toBuilder().setBatchSizeBytes(batchSizeBytes).build();
        }

        public @UnknownKeyFor @NonNull @Initialized TypedWrite<UserT, DestinationT> withBatchMaxBufferingDuration(@Nullable @UnknownKeyFor @Initialized Duration batchMaxBufferingDuration) {
            return this.toBuilder().setBatchMaxBufferingDuration(batchMaxBufferingDuration).build();
        }

        public @UnknownKeyFor @NonNull @Initialized TypedWrite<UserT, DestinationT> withTempDirectory(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized ResourceId> tempDirectory) {
            return this.toBuilder().setTempDirectory(tempDirectory).build();
        }

        public @UnknownKeyFor @NonNull @Initialized TypedWrite<UserT, DestinationT> withTempDirectory(@UnknownKeyFor @NonNull @Initialized ResourceId tempDirectory) {
            return this.withTempDirectory(ValueProvider.StaticValueProvider.of(tempDirectory));
        }

        public @UnknownKeyFor @NonNull @Initialized TypedWrite<UserT, DestinationT> withShardNameTemplate(@UnknownKeyFor @NonNull @Initialized String shardTemplate) {
            return this.toBuilder().setShardTemplate(shardTemplate).build();
        }

        public @UnknownKeyFor @NonNull @Initialized TypedWrite<UserT, DestinationT> withSuffix(@UnknownKeyFor @NonNull @Initialized String filenameSuffix) {
            return this.toBuilder().setFilenameSuffix(filenameSuffix).build();
        }

        public @UnknownKeyFor @NonNull @Initialized TypedWrite<UserT, DestinationT> withNumShards(@UnknownKeyFor @NonNull @Initialized int numShards) {
            Preconditions.checkArgument((numShards >= 0 ? 1 : 0) != 0);
            if (numShards == 0) {
                return this.withNumShards(null);
            }
            return this.withNumShards(ValueProvider.StaticValueProvider.of(numShards));
        }

        public @UnknownKeyFor @NonNull @Initialized TypedWrite<UserT, DestinationT> withNumShards(@Nullable @UnknownKeyFor @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized Integer> numShards) {
            return this.toBuilder().setNumShards(numShards).build();
        }

        public @UnknownKeyFor @NonNull @Initialized TypedWrite<UserT, DestinationT> withoutSharding() {
            return this.withNumShards(1).withShardNameTemplate("");
        }

        public @UnknownKeyFor @NonNull @Initialized TypedWrite<UserT, DestinationT> withDelimiter(@UnknownKeyFor @NonNull @Initialized char @UnknownKeyFor @NonNull @Initialized [] delimiter) {
            return this.toBuilder().setDelimiter(delimiter).build();
        }

        public @UnknownKeyFor @NonNull @Initialized TypedWrite<UserT, DestinationT> withHeader(@Nullable @UnknownKeyFor @Initialized String header) {
            return this.toBuilder().setHeader(header).build();
        }

        public @UnknownKeyFor @NonNull @Initialized TypedWrite<UserT, DestinationT> withFooter(@Nullable @UnknownKeyFor @Initialized String footer) {
            return this.toBuilder().setFooter(footer).build();
        }

        public @UnknownKeyFor @NonNull @Initialized TypedWrite<UserT, DestinationT> withWritableByteChannelFactory(@UnknownKeyFor @NonNull @Initialized FileBasedSink.WritableByteChannelFactory writableByteChannelFactory) {
            return this.toBuilder().setWritableByteChannelFactory(writableByteChannelFactory).build();
        }

        public @UnknownKeyFor @NonNull @Initialized TypedWrite<UserT, DestinationT> withCompression(@UnknownKeyFor @NonNull @Initialized Compression compression) {
            Preconditions.checkArgument((compression != null ? 1 : 0) != 0, (Object)"compression can not be null");
            return this.withWritableByteChannelFactory(FileBasedSink.CompressionType.fromCanonical(compression));
        }

        public @UnknownKeyFor @NonNull @Initialized TypedWrite<UserT, DestinationT> withWindowedWrites() {
            return this.toBuilder().setWindowedWrites(true).build();
        }

        public @UnknownKeyFor @NonNull @Initialized TypedWrite<UserT, DestinationT> withAutoSharding() {
            return this.toBuilder().setAutoSharding(true).build();
        }

        public @UnknownKeyFor @NonNull @Initialized TypedWrite<UserT, DestinationT> withNoSpilling() {
            return this.toBuilder().setNoSpilling(true).build();
        }

        public @UnknownKeyFor @NonNull @Initialized TypedWrite<UserT, DestinationT> withBadRecordErrorHandler(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized ErrorHandler<@UnknownKeyFor @NonNull @Initialized BadRecord, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> errorHandler) {
            return this.toBuilder().setBadRecordErrorHandler(errorHandler).build();
        }

        public @UnknownKeyFor @NonNull @Initialized TypedWrite<UserT, DestinationT> skipIfEmpty() {
            return this.toBuilder().setSkipIfEmpty(true).build();
        }

        private @UnknownKeyFor @NonNull @Initialized FileBasedSink.DynamicDestinations<UserT, DestinationT, @UnknownKeyFor @NonNull @Initialized String> resolveDynamicDestinations() {
            FileBasedSink.DynamicDestinations<UserT, Object, String> dynamicDestinations = this.getDynamicDestinations();
            if (dynamicDestinations == null) {
                if (this.getDestinationFunction() != null) {
                    dynamicDestinations = DynamicFileDestinations.toDefaultPolicies(this.getDestinationFunction(), this.getEmptyDestination(), this.getFormatFunction());
                } else {
                    FileBasedSink.FilenamePolicy usedFilenamePolicy = this.getFilenamePolicy();
                    if (usedFilenamePolicy == null) {
                        usedFilenamePolicy = DefaultFilenamePolicy.fromStandardParameters(this.getFilenamePrefix(), this.getShardTemplate(), this.getFilenameSuffix(), this.getWindowedWrites());
                    }
                    dynamicDestinations = DynamicFileDestinations.constant(usedFilenamePolicy, this.getFormatFunction());
                }
            }
            return dynamicDestinations;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized WriteFilesResult<DestinationT> expand(@UnknownKeyFor @NonNull @Initialized PCollection<UserT> input) {
            ValueProvider<ResourceId> tempDirectory;
            Preconditions.checkState((this.getFilenamePrefix() != null || this.getTempDirectory() != null ? 1 : 0) != 0, (Object)"Need to set either the filename prefix or the tempDirectory of a TextIO.Write transform.");
            ArrayList allToArgs = Lists.newArrayList((Object[])new Serializable[]{this.getFilenamePolicy(), this.getDynamicDestinations(), this.getFilenamePrefix(), this.getDestinationFunction()});
            Preconditions.checkArgument((1 == Iterables.size((Iterable)allToArgs.stream().filter(arg_0 -> ((Predicate)Predicates.notNull()).apply(arg_0)).collect(Collectors.toList())) ? 1 : 0) != 0, (Object)"Exactly one of filename policy, dynamic destinations, filename prefix, or destination function must be set");
            if (this.getDynamicDestinations() != null) {
                Preconditions.checkArgument((this.getFormatFunction() == null ? 1 : 0) != 0, (Object)"A format function should not be specified with DynamicDestinations. Use DynamicDestinations.formatRecord instead");
            }
            if (this.getFilenamePolicy() != null || this.getDynamicDestinations() != null) {
                Preconditions.checkState((this.getShardTemplate() == null && this.getFilenameSuffix() == null ? 1 : 0) != 0, (Object)"shardTemplate and filenameSuffix should only be used with the default filename policy");
            }
            if ((tempDirectory = this.getTempDirectory()) == null) {
                tempDirectory = this.getFilenamePrefix();
            }
            WriteFiles write = WriteFiles.to(new TextSink<UserT, DestinationT>(tempDirectory, this.resolveDynamicDestinations(), this.getDelimiter(), this.getHeader(), this.getFooter(), this.getWritableByteChannelFactory()));
            if (this.getNumShards() != null) {
                write = write.withNumShards(this.getNumShards());
            }
            if (this.getWindowedWrites()) {
                write = write.withWindowedWrites();
            }
            if (this.getAutoSharding()) {
                write = write.withAutoSharding();
            }
            if (this.getNoSpilling()) {
                write = write.withNoSpilling();
            }
            if (this.getBadRecordErrorHandler() != null) {
                write = write.withBadRecordErrorHandler(this.getBadRecordErrorHandler());
            }
            if (this.getSkipIfEmpty()) {
                write = write.withSkipIfEmpty();
            }
            if (this.getBatchSize() != null) {
                write = write.withBatchSize(this.getBatchSize());
            }
            if (this.getBatchSizeBytes() != null) {
                write = write.withBatchSizeBytes(this.getBatchSizeBytes());
            }
            if (this.getBatchMaxBufferingDuration() != null) {
                write = write.withBatchMaxBufferingDuration(this.getBatchMaxBufferingDuration());
            }
            return (WriteFilesResult)input.apply("WriteFiles", write);
        }

        @Override
        public void populateDisplayData(@UnknownKeyFor @NonNull @Initialized DisplayData.Builder builder) {
            super.populateDisplayData(builder);
            this.resolveDynamicDestinations().populateDisplayData(builder);
            builder.addIfNotNull(DisplayData.item("numShards", this.getNumShards()).withLabel("Maximum Output Shards")).addIfNotNull(DisplayData.item("tempDirectory", this.getTempDirectory()).withLabel("Directory for temporary files")).addIfNotNull(DisplayData.item("fileHeader", this.getHeader()).withLabel("File Header")).addIfNotNull(DisplayData.item("fileFooter", this.getFooter()).withLabel("File Footer")).add(DisplayData.item("writableByteChannelFactory", this.getWritableByteChannelFactory().toString()).withLabel("Compression/Transformation Type"));
        }

        @AutoValue.Builder
        static abstract class Builder<@UnknownKeyFor UserT, @UnknownKeyFor DestinationT> {
            Builder() {
            }

            abstract @UnknownKeyFor @NonNull @Initialized Builder<UserT, DestinationT> setFilenamePrefix(@Nullable @UnknownKeyFor @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized ResourceId> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<UserT, DestinationT> setTempDirectory(@Nullable @UnknownKeyFor @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized ResourceId> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<UserT, DestinationT> setShardTemplate(@Nullable @UnknownKeyFor @Initialized String var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<UserT, DestinationT> setFilenameSuffix(@Nullable @UnknownKeyFor @Initialized String var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<UserT, DestinationT> setHeader(@Nullable @UnknownKeyFor @Initialized String var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<UserT, DestinationT> setFooter(@Nullable @UnknownKeyFor @Initialized String var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<UserT, DestinationT> setDelimiter(@UnknownKeyFor @NonNull @Initialized char @UnknownKeyFor @NonNull @Initialized [] var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<UserT, DestinationT> setFilenamePolicy(@Nullable @UnknownKeyFor @Initialized FileBasedSink.FilenamePolicy var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<UserT, DestinationT> setDynamicDestinations(@Nullable @UnknownKeyFor @Initialized FileBasedSink.DynamicDestinations<UserT, DestinationT, @UnknownKeyFor @NonNull @Initialized String> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<UserT, DestinationT> setDestinationFunction(@Nullable @UnknownKeyFor @Initialized SerializableFunction<UserT, @UnknownKeyFor @NonNull @Initialized DefaultFilenamePolicy.Params> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<UserT, DestinationT> setEmptyDestination(@UnknownKeyFor @NonNull @Initialized DefaultFilenamePolicy.Params var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<UserT, DestinationT> setFormatFunction(@Nullable @UnknownKeyFor @Initialized SerializableFunction<UserT, @UnknownKeyFor @NonNull @Initialized String> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<UserT, DestinationT> setNumShards(@Nullable @UnknownKeyFor @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized Integer> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<UserT, DestinationT> setBatchSize(@Nullable @UnknownKeyFor @Initialized Integer var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<UserT, DestinationT> setBatchSizeBytes(@Nullable @UnknownKeyFor @Initialized Integer var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<UserT, DestinationT> setBatchMaxBufferingDuration(@Nullable @UnknownKeyFor @Initialized Duration var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<UserT, DestinationT> setWindowedWrites(@UnknownKeyFor @NonNull @Initialized boolean var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<UserT, DestinationT> setAutoSharding(@UnknownKeyFor @NonNull @Initialized boolean var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<UserT, DestinationT> setNoSpilling(@UnknownKeyFor @NonNull @Initialized boolean var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<UserT, DestinationT> setSkipIfEmpty(@UnknownKeyFor @NonNull @Initialized boolean var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<UserT, DestinationT> setWritableByteChannelFactory(@UnknownKeyFor @NonNull @Initialized FileBasedSink.WritableByteChannelFactory var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<UserT, DestinationT> setBadRecordErrorHandler(/*
             * Issues handling annotations - annotations may be inaccurate
             */
            @Nullable @UnknownKeyFor @Initialized ErrorHandler<@UnknownKeyFor @NonNull @Initialized BadRecord, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> var1);

            abstract @UnknownKeyFor @NonNull @Initialized TypedWrite<UserT, DestinationT> build();
        }
    }

    @AutoValue
    public static abstract class ReadFiles
    extends PTransform<PCollection<FileIO.ReadableFile>, PCollection<String>> {
        abstract @UnknownKeyFor @NonNull @Initialized long getDesiredBundleSizeBytes();

        abstract @UnknownKeyFor @NonNull @Initialized byte @Nullable @UnknownKeyFor @Initialized [] getDelimiter();

        abstract @UnknownKeyFor @NonNull @Initialized int getSkipHeaderLines();

        abstract @UnknownKeyFor @NonNull @Initialized Builder toBuilder();

        @VisibleForTesting
        @UnknownKeyFor @NonNull @Initialized ReadFiles withDesiredBundleSizeBytes(@UnknownKeyFor @NonNull @Initialized long desiredBundleSizeBytes) {
            return this.toBuilder().setDesiredBundleSizeBytes(desiredBundleSizeBytes).build();
        }

        public @UnknownKeyFor @NonNull @Initialized ReadFiles withDelimiter(@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] delimiter) {
            return this.toBuilder().setDelimiter(delimiter).build();
        }

        public @UnknownKeyFor @NonNull @Initialized ReadFiles withSkipHeaderLines(@UnknownKeyFor @NonNull @Initialized int skipHeaderLines) {
            return this.toBuilder().setSkipHeaderLines(skipHeaderLines).build();
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized String> expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized FileIO.ReadableFile> input) {
            return (PCollection)input.apply("Read all via FileBasedSource", new ReadAllViaFileBasedSource<String>(this.getDesiredBundleSizeBytes(), new CreateTextSourceFn(this.getDelimiter(), this.getSkipHeaderLines()), (Coder<String>)StringUtf8Coder.of()));
        }

        @Override
        public void populateDisplayData(@UnknownKeyFor @NonNull @Initialized DisplayData.Builder builder) {
            super.populateDisplayData(builder);
            builder.addIfNotNull(DisplayData.item("delimiter", Arrays.toString(this.getDelimiter())).withLabel("Custom delimiter to split records"));
        }

        private static class CreateTextSourceFn
        implements SerializableFunction<String, FileBasedSource<String>> {
            private @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] delimiter;
            private @UnknownKeyFor @NonNull @Initialized int skipHeaderLines;

            private CreateTextSourceFn(@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] delimiter, @UnknownKeyFor @NonNull @Initialized int skipHeaderLines) {
                this.delimiter = delimiter;
                this.skipHeaderLines = skipHeaderLines;
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized FileBasedSource<@UnknownKeyFor @NonNull @Initialized String> apply(@UnknownKeyFor @NonNull @Initialized String input) {
                return new TextSource(ValueProvider.StaticValueProvider.of(input), EmptyMatchTreatment.DISALLOW, this.delimiter, this.skipHeaderLines);
            }
        }

        @AutoValue.Builder
        static abstract class Builder {
            Builder() {
            }

            abstract @UnknownKeyFor @NonNull @Initialized Builder setDesiredBundleSizeBytes(@UnknownKeyFor @NonNull @Initialized long var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setDelimiter(@UnknownKeyFor @NonNull @Initialized byte @Nullable @UnknownKeyFor @Initialized [] var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setSkipHeaderLines(@UnknownKeyFor @NonNull @Initialized int var1);

            abstract @UnknownKeyFor @NonNull @Initialized ReadFiles build();
        }
    }

    @Deprecated
    @AutoValue
    public static abstract class ReadAll
    extends PTransform<PCollection<String>, PCollection<String>> {
        abstract @UnknownKeyFor @NonNull @Initialized FileIO.MatchConfiguration getMatchConfiguration();

        abstract @UnknownKeyFor @NonNull @Initialized Compression getCompression();

        abstract @UnknownKeyFor @NonNull @Initialized byte @Nullable @UnknownKeyFor @Initialized [] getDelimiter();

        abstract @UnknownKeyFor @NonNull @Initialized int getSkipHeaderLines();

        abstract @UnknownKeyFor @NonNull @Initialized Builder toBuilder();

        public @UnknownKeyFor @NonNull @Initialized ReadAll withMatchConfiguration(@UnknownKeyFor @NonNull @Initialized FileIO.MatchConfiguration configuration) {
            return this.toBuilder().setMatchConfiguration(configuration).build();
        }

        @Deprecated
        public @UnknownKeyFor @NonNull @Initialized ReadAll withCompressionType(@UnknownKeyFor @NonNull @Initialized CompressionType compressionType) {
            return this.withCompression(compressionType.canonical);
        }

        public @UnknownKeyFor @NonNull @Initialized ReadAll withCompression(@UnknownKeyFor @NonNull @Initialized Compression compression) {
            return this.toBuilder().setCompression(compression).build();
        }

        public @UnknownKeyFor @NonNull @Initialized ReadAll withEmptyMatchTreatment(@UnknownKeyFor @NonNull @Initialized EmptyMatchTreatment treatment) {
            return this.withMatchConfiguration(this.getMatchConfiguration().withEmptyMatchTreatment(treatment));
        }

        public @UnknownKeyFor @NonNull @Initialized ReadAll watchForNewFiles(@UnknownKeyFor @NonNull @Initialized Duration pollInterval, /*
         * Issues handling annotations - annotations may be inaccurate
         */
         @UnknownKeyFor @NonNull @Initialized Watch.Growth.TerminationCondition<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> terminationCondition, @UnknownKeyFor @NonNull @Initialized boolean matchUpdatedFiles) {
            return this.withMatchConfiguration(this.getMatchConfiguration().continuously(pollInterval, terminationCondition, matchUpdatedFiles));
        }

        public @UnknownKeyFor @NonNull @Initialized ReadAll watchForNewFiles(@UnknownKeyFor @NonNull @Initialized Duration pollInterval, /*
         * Issues handling annotations - annotations may be inaccurate
         */
         @UnknownKeyFor @NonNull @Initialized Watch.Growth.TerminationCondition<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> terminationCondition) {
            return this.watchForNewFiles(pollInterval, terminationCondition, false);
        }

        @UnknownKeyFor @NonNull @Initialized ReadAll withDelimiter(@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] delimiter) {
            return this.toBuilder().setDelimiter(delimiter).build();
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized String> expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized String> input) {
            return input.apply(FileIO.matchAll().withConfiguration(this.getMatchConfiguration())).apply(FileIO.readMatches().withCompression(this.getCompression()).withDirectoryTreatment(FileIO.ReadMatches.DirectoryTreatment.PROHIBIT)).apply(TextIO.readFiles().withDelimiter(this.getDelimiter()));
        }

        @Override
        public void populateDisplayData(@UnknownKeyFor @NonNull @Initialized DisplayData.Builder builder) {
            super.populateDisplayData(builder);
            builder.add(DisplayData.item("compressionType", this.getCompression().toString()).withLabel("Compression Type")).addIfNotNull(DisplayData.item("delimiter", Arrays.toString(this.getDelimiter())).withLabel("Custom delimiter to split records")).include("matchConfiguration", this.getMatchConfiguration());
        }

        @AutoValue.Builder
        static abstract class Builder {
            Builder() {
            }

            abstract @UnknownKeyFor @NonNull @Initialized Builder setMatchConfiguration(@UnknownKeyFor @NonNull @Initialized FileIO.MatchConfiguration var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setCompression(@UnknownKeyFor @NonNull @Initialized Compression var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setDelimiter(@UnknownKeyFor @NonNull @Initialized byte @Nullable @UnknownKeyFor @Initialized [] var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setSkipHeaderLines(@UnknownKeyFor @NonNull @Initialized int var1);

            abstract @UnknownKeyFor @NonNull @Initialized ReadAll build();
        }
    }

    @AutoValue
    public static abstract class Read
    extends PTransform<PBegin, PCollection<String>> {
        abstract @Nullable @UnknownKeyFor @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> getFilepattern();

        abstract @UnknownKeyFor @NonNull @Initialized FileIO.MatchConfiguration getMatchConfiguration();

        abstract @UnknownKeyFor @NonNull @Initialized boolean getHintMatchesManyFiles();

        abstract @UnknownKeyFor @NonNull @Initialized Compression getCompression();

        abstract @UnknownKeyFor @NonNull @Initialized byte @Nullable @UnknownKeyFor @Initialized [] getDelimiter();

        abstract @UnknownKeyFor @NonNull @Initialized int getSkipHeaderLines();

        abstract @UnknownKeyFor @NonNull @Initialized Builder toBuilder();

        public @UnknownKeyFor @NonNull @Initialized Read from(@UnknownKeyFor @NonNull @Initialized String filepattern) {
            Preconditions.checkArgument((filepattern != null ? 1 : 0) != 0, (Object)"filepattern can not be null");
            return this.from(ValueProvider.StaticValueProvider.of(filepattern));
        }

        public @UnknownKeyFor @NonNull @Initialized Read from(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> filepattern) {
            Preconditions.checkArgument((filepattern != null ? 1 : 0) != 0, (Object)"filepattern can not be null");
            return this.toBuilder().setFilepattern(filepattern).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Read withMatchConfiguration(@UnknownKeyFor @NonNull @Initialized FileIO.MatchConfiguration matchConfiguration) {
            return this.toBuilder().setMatchConfiguration(matchConfiguration).build();
        }

        @Deprecated
        public @UnknownKeyFor @NonNull @Initialized Read withCompressionType(@UnknownKeyFor @NonNull @Initialized CompressionType compressionType) {
            return this.withCompression(compressionType.canonical);
        }

        public @UnknownKeyFor @NonNull @Initialized Read withCompression(@UnknownKeyFor @NonNull @Initialized Compression compression) {
            return this.toBuilder().setCompression(compression).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Read watchForNewFiles(@UnknownKeyFor @NonNull @Initialized Duration pollInterval, /*
         * Issues handling annotations - annotations may be inaccurate
         */
         @UnknownKeyFor @NonNull @Initialized Watch.Growth.TerminationCondition<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> terminationCondition, @UnknownKeyFor @NonNull @Initialized boolean matchUpdatedFiles) {
            return this.withMatchConfiguration(this.getMatchConfiguration().continuously(pollInterval, terminationCondition, matchUpdatedFiles));
        }

        public @UnknownKeyFor @NonNull @Initialized Read watchForNewFiles(@UnknownKeyFor @NonNull @Initialized Duration pollInterval, /*
         * Issues handling annotations - annotations may be inaccurate
         */
         @UnknownKeyFor @NonNull @Initialized Watch.Growth.TerminationCondition<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> terminationCondition) {
            return this.watchForNewFiles(pollInterval, terminationCondition, false);
        }

        public @UnknownKeyFor @NonNull @Initialized Read withHintMatchesManyFiles() {
            return this.toBuilder().setHintMatchesManyFiles(true).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Read withEmptyMatchTreatment(@UnknownKeyFor @NonNull @Initialized EmptyMatchTreatment treatment) {
            return this.withMatchConfiguration(this.getMatchConfiguration().withEmptyMatchTreatment(treatment));
        }

        public @UnknownKeyFor @NonNull @Initialized Read withDelimiter(@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] delimiter) {
            Preconditions.checkArgument((delimiter != null ? 1 : 0) != 0, (Object)"delimiter can not be null");
            Preconditions.checkArgument((!Read.isSelfOverlapping(delimiter) ? 1 : 0) != 0, (Object)"delimiter must not self-overlap");
            return this.toBuilder().setDelimiter(delimiter).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Read withSkipHeaderLines(@UnknownKeyFor @NonNull @Initialized int skipHeaderLines) {
            return this.toBuilder().setSkipHeaderLines(skipHeaderLines).build();
        }

        static @UnknownKeyFor @NonNull @Initialized boolean isSelfOverlapping(@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] s) {
            for (int i = 1; i < s.length - 1; ++i) {
                if (!ByteBuffer.wrap(s, 0, i).equals(ByteBuffer.wrap(s, s.length - i, i))) continue;
                return true;
            }
            return false;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized String> expand(@UnknownKeyFor @NonNull @Initialized PBegin input) {
            Preconditions.checkNotNull(this.getFilepattern(), (Object)"need to set the filepattern of a TextIO.Read transform");
            if (this.getMatchConfiguration().getWatchInterval() == null && !this.getHintMatchesManyFiles()) {
                return (PCollection)input.apply("Read", org.apache.beam.sdk.io.Read.from(this.getSource()));
            }
            return ((PCollection)input.apply("Create filepattern", Create.ofProvider(this.getFilepattern(), StringUtf8Coder.of()))).apply("Match All", FileIO.matchAll().withConfiguration(this.getMatchConfiguration())).apply("Read Matches", FileIO.readMatches().withCompression(this.getCompression()).withDirectoryTreatment(FileIO.ReadMatches.DirectoryTreatment.PROHIBIT)).apply("Via ReadFiles", TextIO.readFiles().withDelimiter(this.getDelimiter()).withSkipHeaderLines(this.getSkipHeaderLines()));
        }

        protected @UnknownKeyFor @NonNull @Initialized FileBasedSource<@UnknownKeyFor @NonNull @Initialized String> getSource() {
            return CompressedSource.from(new TextSource(this.getFilepattern(), this.getMatchConfiguration().getEmptyMatchTreatment(), this.getDelimiter(), this.getSkipHeaderLines())).withCompression(this.getCompression());
        }

        @Override
        public void populateDisplayData(@UnknownKeyFor @NonNull @Initialized DisplayData.Builder builder) {
            super.populateDisplayData(builder);
            builder.add(DisplayData.item("compressionType", this.getCompression().toString()).withLabel("Compression Type")).addIfNotNull(DisplayData.item("filePattern", this.getFilepattern()).withLabel("File Pattern")).include("matchConfiguration", this.getMatchConfiguration()).addIfNotNull(DisplayData.item("delimiter", Arrays.toString(this.getDelimiter())).withLabel("Custom delimiter to split records"));
        }

        @AutoValue.Builder
        static abstract class Builder {
            Builder() {
            }

            abstract @UnknownKeyFor @NonNull @Initialized Builder setFilepattern(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setMatchConfiguration(@UnknownKeyFor @NonNull @Initialized FileIO.MatchConfiguration var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setHintMatchesManyFiles(@UnknownKeyFor @NonNull @Initialized boolean var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setCompression(@UnknownKeyFor @NonNull @Initialized Compression var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setDelimiter(@UnknownKeyFor @NonNull @Initialized byte @Nullable @UnknownKeyFor @Initialized [] var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setSkipHeaderLines(@UnknownKeyFor @NonNull @Initialized int var1);

            abstract @UnknownKeyFor @NonNull @Initialized Read build();
        }
    }
}

