/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.fn.server;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.apache.beam.sdk.fn.channel.SocketAddressFactory;
import org.apache.beam.sdk.fn.server.GrpcContextHeaderAccessorProvider;
import org.apache.beam.vendor.grpc.v1p60p1.io.grpc.BindableService;
import org.apache.beam.vendor.grpc.v1p60p1.io.grpc.Server;
import org.apache.beam.vendor.grpc.v1p60p1.io.grpc.ServerInterceptor;
import org.apache.beam.vendor.grpc.v1p60p1.io.grpc.ServerInterceptors;
import org.apache.beam.vendor.grpc.v1p60p1.io.grpc.netty.NettyServerBuilder;
import org.apache.beam.vendor.grpc.v1p60p1.io.netty.channel.EventLoopGroup;
import org.apache.beam.vendor.grpc.v1p60p1.io.netty.channel.epoll.EpollEventLoopGroup;
import org.apache.beam.vendor.grpc.v1p60p1.io.netty.channel.epoll.EpollServerDomainSocketChannel;
import org.apache.beam.vendor.grpc.v1p60p1.io.netty.channel.epoll.EpollServerSocketChannel;
import org.apache.beam.vendor.grpc.v1p60p1.io.netty.channel.unix.DomainSocketAddress;
import org.apache.beam.vendor.grpc.v1p60p1.io.netty.util.internal.ThreadLocalRandom;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.net.HostAndPort;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public abstract class ServerFactory {
    private static final @UnknownKeyFor @NonNull @Initialized int KEEP_ALIVE_TIME_SEC = 20;

    public static @UnknownKeyFor @NonNull @Initialized ServerFactory createDefault() {
        return new InetSocketAddressServerFactory(UrlFactory.createDefault());
    }

    public static @UnknownKeyFor @NonNull @Initialized ServerFactory createWithUrlFactory(@UnknownKeyFor @NonNull @Initialized UrlFactory urlFactory) {
        return new InetSocketAddressServerFactory(urlFactory);
    }

    public static @UnknownKeyFor @NonNull @Initialized ServerFactory createWithPortSupplier(@UnknownKeyFor @NonNull @Initialized Supplier<@UnknownKeyFor @NonNull @Initialized Integer> portSupplier) {
        return new InetSocketAddressServerFactory(UrlFactory.createDefault(), portSupplier);
    }

    public static @UnknownKeyFor @NonNull @Initialized ServerFactory createWithUrlFactoryAndPortSupplier(@UnknownKeyFor @NonNull @Initialized UrlFactory urlFactory, @UnknownKeyFor @NonNull @Initialized Supplier<@UnknownKeyFor @NonNull @Initialized Integer> portSupplier) {
        return new InetSocketAddressServerFactory(urlFactory, portSupplier);
    }

    public static @UnknownKeyFor @NonNull @Initialized ServerFactory createEpollSocket() {
        return new EpollSocket();
    }

    public static @UnknownKeyFor @NonNull @Initialized ServerFactory createEpollDomainSocket() {
        return new EpollDomainSocket();
    }

    public abstract @UnknownKeyFor @NonNull @Initialized Server allocateAddressAndCreate(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized BindableService> var1, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Endpoints.ApiServiceDescriptor.Builder var2) throws @UnknownKeyFor @NonNull @Initialized IOException;

    public abstract @UnknownKeyFor @NonNull @Initialized Server create(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized BindableService> var1, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Endpoints.ApiServiceDescriptor var2) throws @UnknownKeyFor @NonNull @Initialized IOException;

    @FunctionalInterface
    public static interface UrlFactory {
        public @UnknownKeyFor @NonNull @Initialized String createUrl(@UnknownKeyFor @NonNull @Initialized String var1, @UnknownKeyFor @NonNull @Initialized int var2);

        public static @UnknownKeyFor @NonNull @Initialized UrlFactory createDefault() {
            return (host, port) -> HostAndPort.fromParts((String)host, (int)port).toString();
        }
    }

    private static class EpollSocket
    extends ServerFactory {
        private EpollSocket() {
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Server allocateAddressAndCreate(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized BindableService> services, // Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized Endpoints.ApiServiceDescriptor.Builder apiServiceDescriptor) throws @UnknownKeyFor @NonNull @Initialized IOException {
            InetSocketAddress address = new InetSocketAddress(InetAddress.getLoopbackAddress(), 0);
            Server server = EpollSocket.createServer(services, address);
            apiServiceDescriptor.setUrl(HostAndPort.fromParts((String)address.getHostName(), (int)server.getPort()).toString());
            return server;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Server create(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized BindableService> services, // Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized Endpoints.ApiServiceDescriptor serviceDescriptor) throws @UnknownKeyFor @NonNull @Initialized IOException {
            SocketAddress socketAddress = SocketAddressFactory.createFrom(serviceDescriptor.getUrl());
            Preconditions.checkArgument((boolean)(socketAddress instanceof InetSocketAddress), (String)"%s requires a host:port socket address, got %s", (Object)EpollSocket.class.getSimpleName(), (Object)serviceDescriptor.getUrl());
            return EpollSocket.createServer(services, (InetSocketAddress)socketAddress);
        }

        private static @UnknownKeyFor @NonNull @Initialized Server createServer(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized BindableService> services, @UnknownKeyFor @NonNull @Initialized InetSocketAddress socket) throws @UnknownKeyFor @NonNull @Initialized IOException {
            NettyServerBuilder builder = NettyServerBuilder.forAddress((SocketAddress)socket).channelType(EpollServerSocketChannel.class).workerEventLoopGroup((EventLoopGroup)new EpollEventLoopGroup()).bossEventLoopGroup((EventLoopGroup)new EpollEventLoopGroup()).maxInboundMessageSize(Integer.MAX_VALUE).permitKeepAliveTime(20L, TimeUnit.SECONDS);
            for (BindableService service : services) {
                builder.addService(ServerInterceptors.intercept((BindableService)service, (ServerInterceptor[])new ServerInterceptor[]{GrpcContextHeaderAccessorProvider.interceptor()}));
            }
            return builder.build().start();
        }
    }

    private static class EpollDomainSocket
    extends ServerFactory {
        private EpollDomainSocket() {
        }

        private static @UnknownKeyFor @NonNull @Initialized File chooseRandomTmpFile(@UnknownKeyFor @NonNull @Initialized int port) {
            return new File(System.getProperty("java.io.tmpdir"), String.format("fnapi%d.sock", port));
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Server allocateAddressAndCreate(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized BindableService> services, // Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized Endpoints.ApiServiceDescriptor.Builder apiServiceDescriptor) throws @UnknownKeyFor @NonNull @Initialized IOException {
            File tmp;
            while ((tmp = EpollDomainSocket.chooseRandomTmpFile(ThreadLocalRandom.current().nextInt(10000))).exists()) {
            }
            apiServiceDescriptor.setUrl("unix://" + tmp.getAbsolutePath());
            return this.create(services, apiServiceDescriptor.build());
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Server create(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized BindableService> services, // Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized Endpoints.ApiServiceDescriptor serviceDescriptor) throws @UnknownKeyFor @NonNull @Initialized IOException {
            SocketAddress socketAddress = SocketAddressFactory.createFrom(serviceDescriptor.getUrl());
            Preconditions.checkArgument((boolean)(socketAddress instanceof DomainSocketAddress), (String)"%s requires a Unix domain socket address, got %s", (Object)EpollDomainSocket.class.getSimpleName(), (Object)serviceDescriptor.getUrl());
            return EpollDomainSocket.createServer(services, (DomainSocketAddress)socketAddress);
        }

        private static @UnknownKeyFor @NonNull @Initialized Server createServer(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized BindableService> services, @UnknownKeyFor @NonNull @Initialized DomainSocketAddress domainSocket) throws @UnknownKeyFor @NonNull @Initialized IOException {
            NettyServerBuilder builder = NettyServerBuilder.forAddress((SocketAddress)domainSocket).channelType(EpollServerDomainSocketChannel.class).workerEventLoopGroup((EventLoopGroup)new EpollEventLoopGroup()).bossEventLoopGroup((EventLoopGroup)new EpollEventLoopGroup()).maxInboundMessageSize(Integer.MAX_VALUE).permitKeepAliveTime(20L, TimeUnit.SECONDS);
            for (BindableService service : services) {
                builder.addService(ServerInterceptors.intercept((BindableService)service, (ServerInterceptor[])new ServerInterceptor[]{GrpcContextHeaderAccessorProvider.interceptor()}));
            }
            return builder.build().start();
        }
    }

    public static class InetSocketAddressServerFactory
    extends ServerFactory {
        private final @UnknownKeyFor @NonNull @Initialized UrlFactory urlFactory;
        private final @UnknownKeyFor @NonNull @Initialized Supplier<@UnknownKeyFor @NonNull @Initialized Integer> portSupplier;

        private InetSocketAddressServerFactory(@UnknownKeyFor @NonNull @Initialized UrlFactory urlFactory) {
            this(urlFactory, () -> 0);
        }

        private InetSocketAddressServerFactory(@UnknownKeyFor @NonNull @Initialized UrlFactory urlFactory, @UnknownKeyFor @NonNull @Initialized Supplier<@UnknownKeyFor @NonNull @Initialized Integer> portSupplier) {
            this.urlFactory = urlFactory;
            this.portSupplier = portSupplier;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Server allocateAddressAndCreate(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized BindableService> services, // Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized Endpoints.ApiServiceDescriptor.Builder apiServiceDescriptor) throws @UnknownKeyFor @NonNull @Initialized IOException {
            InetSocketAddress address = new InetSocketAddress(InetAddress.getLoopbackAddress(), (int)this.portSupplier.get());
            Server server = InetSocketAddressServerFactory.createServer(services, address);
            apiServiceDescriptor.setUrl(this.urlFactory.createUrl(address.getHostName(), server.getPort()));
            return server;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Server create(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized BindableService> services, // Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized Endpoints.ApiServiceDescriptor serviceDescriptor) throws @UnknownKeyFor @NonNull @Initialized IOException {
            SocketAddress socketAddress = SocketAddressFactory.createFrom(serviceDescriptor.getUrl());
            Preconditions.checkArgument((boolean)(socketAddress instanceof InetSocketAddress), (String)"%s %s requires a host:port socket address, got %s", (Object)this.getClass().getSimpleName(), (Object)ServerFactory.class.getSimpleName(), (Object)serviceDescriptor.getUrl());
            return InetSocketAddressServerFactory.createServer(services, (InetSocketAddress)socketAddress);
        }

        private static @UnknownKeyFor @NonNull @Initialized Server createServer(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized BindableService> services, @UnknownKeyFor @NonNull @Initialized InetSocketAddress socket) throws @UnknownKeyFor @NonNull @Initialized IOException {
            NettyServerBuilder builder = NettyServerBuilder.forPort((int)socket.getPort()).maxInboundMessageSize(Integer.MAX_VALUE).permitKeepAliveTime(20L, TimeUnit.SECONDS);
            services.stream().forEach(service -> {
                NettyServerBuilder cfr_ignored_0 = (NettyServerBuilder)builder.addService(ServerInterceptors.intercept((BindableService)service, (ServerInterceptor[])new ServerInterceptor[]{GrpcContextHeaderAccessorProvider.interceptor()}));
            });
            return builder.build().start();
        }
    }
}

