/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.core.v3.replication;

import com.amazon.redshift.copy.CopyDual;
import com.amazon.redshift.core.QueryExecutor;
import com.amazon.redshift.core.RedshiftStream;
import com.amazon.redshift.core.ReplicationProtocol;
import com.amazon.redshift.core.v3.replication.V3RedshiftReplicationStream;
import com.amazon.redshift.logger.LogLevel;
import com.amazon.redshift.logger.RedshiftLogger;
import com.amazon.redshift.replication.RedshiftReplicationStream;
import com.amazon.redshift.replication.ReplicationType;
import com.amazon.redshift.replication.fluent.CommonOptions;
import com.amazon.redshift.replication.fluent.logical.LogicalReplicationOptions;
import com.amazon.redshift.replication.fluent.physical.PhysicalReplicationOptions;
import com.amazon.redshift.util.GT;
import com.amazon.redshift.util.RedshiftException;
import com.amazon.redshift.util.RedshiftState;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Properties;

public class V3ReplicationProtocol
implements ReplicationProtocol {
    private RedshiftLogger logger;
    private final QueryExecutor queryExecutor;
    private final RedshiftStream pgStream;

    public V3ReplicationProtocol(QueryExecutor queryExecutor, RedshiftStream pgStream) {
        this.queryExecutor = queryExecutor;
        this.pgStream = pgStream;
    }

    @Override
    public RedshiftReplicationStream startLogical(LogicalReplicationOptions options, RedshiftLogger logger) throws SQLException {
        String query = this.createStartLogicalQuery(options);
        return this.initializeReplication(query, options, ReplicationType.LOGICAL, logger);
    }

    @Override
    public RedshiftReplicationStream startPhysical(PhysicalReplicationOptions options, RedshiftLogger logger) throws SQLException {
        String query = this.createStartPhysicalQuery(options);
        return this.initializeReplication(query, options, ReplicationType.PHYSICAL, logger);
    }

    private RedshiftReplicationStream initializeReplication(String query, CommonOptions options, ReplicationType replicationType, RedshiftLogger logger) throws SQLException {
        this.logger = logger;
        if (RedshiftLogger.isEnable()) {
            this.logger.log(LogLevel.DEBUG, " FE=> StartReplication(query: {0})", query);
        }
        this.configureSocketTimeout(options);
        CopyDual copyDual = (CopyDual)this.queryExecutor.startCopy(query, true);
        return new V3RedshiftReplicationStream(copyDual, options.getStartLSNPosition(), options.getStatusInterval(), replicationType, logger);
    }

    private String createStartPhysicalQuery(PhysicalReplicationOptions options) {
        StringBuilder builder = new StringBuilder();
        builder.append("START_REPLICATION");
        if (options.getSlotName() != null) {
            builder.append(" SLOT ").append(options.getSlotName());
        }
        builder.append(" PHYSICAL ").append(options.getStartLSNPosition().asString());
        return builder.toString();
    }

    private String createStartLogicalQuery(LogicalReplicationOptions options) {
        StringBuilder builder = new StringBuilder();
        builder.append("START_REPLICATION SLOT ").append(options.getSlotName()).append(" LOGICAL ").append(options.getStartLSNPosition().asString());
        Properties slotOptions = options.getSlotOptions();
        if (slotOptions.isEmpty()) {
            return builder.toString();
        }
        builder.append(" (");
        boolean isFirst = true;
        for (String name : slotOptions.stringPropertyNames()) {
            if (isFirst) {
                isFirst = false;
            } else {
                builder.append(", ");
            }
            builder.append('\"').append(name).append('\"').append(" ").append('\'').append(slotOptions.getProperty(name)).append('\'');
        }
        builder.append(")");
        return builder.toString();
    }

    private void configureSocketTimeout(CommonOptions options) throws RedshiftException {
        if (options.getStatusInterval() == 0) {
            return;
        }
        try {
            int previousTimeOut = this.pgStream.getSocket().getSoTimeout();
            int minimalTimeOut = previousTimeOut > 0 ? Math.min(previousTimeOut, options.getStatusInterval()) : options.getStatusInterval();
            this.pgStream.getSocket().setSoTimeout(minimalTimeOut);
            this.pgStream.setMinStreamAvailableCheckDelay(0);
        }
        catch (IOException ioe) {
            throw new RedshiftException(GT.tr("The connection attempt failed.", new Object[0]), RedshiftState.CONNECTION_UNABLE_TO_CONNECT, (Throwable)ioe);
        }
    }
}

