/*
 * Decompiled with CFR 0.152.
 */
package org.gridkit.jvmtool.stacktrace.codec.json;

import java.util.concurrent.TimeUnit;
import org.gridkit.jvmtool.event.GenericEvent;

class JfrHelper {
    private static final long NS_PER_MS = TimeUnit.MILLISECONDS.toNanos(1L);

    JfrHelper() {
    }

    public static void setTimestamp(GenericEvent ge, Object val) {
        if (val instanceof Number) {
            ge.timestamp(((Number)val).longValue() / NS_PER_MS);
            return;
        }
        if (val instanceof String) {
            try {
                long ts = Long.parseLong(val.toString());
                ge.timestamp(ts / NS_PER_MS);
                return;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        throw new IllegalArgumentException("Cannot cast " + val + " to time stamp");
    }

    public static void setThreadState(GenericEvent event, Object val) {
        event.tags().put("thread.javaState", JfrHelper.convertThreadState(String.valueOf(val)));
    }

    public static void setAllocationSize(GenericEvent ge, Object val) {
        Long lval = JfrHelper.asLong(val);
        if (lval == null) {
            throw new IllegalArgumentException("Cannot cast " + val + " to number");
        }
        ge.counters().set("jfr.ObjectAllocationInNewTLAB.allocationSize", lval);
    }

    public static void setTLABSize(GenericEvent ge, Object val) {
        Long lval = JfrHelper.asLong(val);
        if (lval == null) {
            throw new IllegalArgumentException("Cannot cast " + val + " to number");
        }
        ge.counters().set("jfr.ObjectAllocationInNewTLAB.tlabSize", lval);
    }

    public static Long asLong(Object value) {
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        if (value instanceof String) {
            try {
                return Long.parseLong((String)value);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        return null;
    }

    private static String convertThreadState(String val) {
        if (val.startsWith("STATE_")) {
            return val.substring("STATE_".length());
        }
        return val;
    }
}

