/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.tableoutput;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.apache.hop.core.Const;
import org.apache.hop.core.RowMetaAndData;
import org.apache.hop.core.database.Database;
import org.apache.hop.core.database.IDatabase;
import org.apache.hop.core.exception.HopDatabaseBatchException;
import org.apache.hop.core.exception.HopDatabaseException;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.logging.ILoggingObject;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.RowDataUtil;
import org.apache.hop.core.row.RowMeta;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransform;
import org.apache.hop.pipeline.transform.ITransformData;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.tableoutput.TableOutputData;
import org.apache.hop.pipeline.transforms.tableoutput.TableOutputField;
import org.apache.hop.pipeline.transforms.tableoutput.TableOutputMeta;

public class TableOutput
extends BaseTransform<TableOutputMeta, TableOutputData> {
    private static final Class<?> PKG = TableOutputMeta.class;

    public TableOutput(TransformMeta transformMeta, TableOutputMeta meta, TableOutputData data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        super(transformMeta, (ITransformMeta)meta, (ITransformData)data, copyNr, pipelineMeta, pipeline);
    }

    public boolean processRow() throws HopException {
        Object[] r = this.getRow();
        if (r == null) {
            if (this.first && ((TableOutputMeta)this.meta).isTruncateTable() && !((TableOutputMeta)this.meta).isOnlyWhenHaveRows()) {
                this.truncateTable();
            }
            return false;
        }
        if (this.first) {
            this.first = false;
            if (((TableOutputMeta)this.meta).isTruncateTable()) {
                this.truncateTable();
            }
            ((TableOutputData)this.data).outputRowMeta = this.getInputRowMeta().clone();
            ((TableOutputMeta)this.meta).getFields(((TableOutputData)this.data).outputRowMeta, this.getTransformName(), null, null, (IVariables)this, this.metadataProvider);
            if (!((TableOutputMeta)this.meta).isSpecifyFields()) {
                ((TableOutputData)this.data).insertRowMeta = this.getInputRowMeta().clone();
            } else {
                TableOutputField tf;
                int i;
                ((TableOutputData)this.data).insertRowMeta = new RowMeta();
                ((TableOutputData)this.data).valuenrs = new int[((TableOutputMeta)this.meta).getFields().size()];
                for (i = 0; i < ((TableOutputMeta)this.meta).getFields().size(); ++i) {
                    tf = ((TableOutputMeta)this.meta).getFields().get(i);
                    ((TableOutputData)this.data).valuenrs[i] = this.getInputRowMeta().indexOfValue(tf.getFieldStream());
                    if (((TableOutputData)this.data).valuenrs[i] >= 0) continue;
                    throw new HopTransformException(BaseMessages.getString(PKG, (String)"TableOutput.Exception.FieldRequired", (String[])new String[]{tf.getFieldStream()}));
                }
                for (i = 0; i < ((TableOutputMeta)this.meta).getFields().size(); ++i) {
                    tf = ((TableOutputMeta)this.meta).getFields().get(i);
                    IValueMeta insValue = this.getInputRowMeta().searchValueMeta(tf.getFieldStream());
                    if (insValue == null) {
                        throw new HopTransformException(BaseMessages.getString(PKG, (String)"TableOutput.Exception.FailedToFindField", (String[])new String[]{tf.getFieldStream()}));
                    }
                    IValueMeta insertValue = insValue.clone();
                    insertValue.setName(tf.getFieldDatabase());
                    ((TableOutputData)this.data).insertRowMeta.addValueMeta(insertValue);
                }
            }
        }
        try {
            Object[] outputRowData = this.writeToTable(this.getInputRowMeta(), r);
            if (outputRowData != null) {
                this.putRow(((TableOutputData)this.data).outputRowMeta, outputRowData);
                this.incrementLinesOutput();
            }
            if (this.checkFeedback(this.getLinesRead()) && this.isBasic()) {
                this.logBasic("linenr " + this.getLinesRead());
            }
        }
        catch (HopException e) {
            this.logError("Because of an error, this transform can't continue: ", e);
            this.setErrors(1L);
            this.stopAll();
            this.setOutputDone();
            return false;
        }
        return true;
    }

    protected Object[] writeToTable(IRowMeta rowMeta, Object[] r) throws HopException {
        Long generatedKey;
        boolean batchProblem;
        List exceptionsList;
        int[] updateCounts;
        boolean rowIsSafe;
        String errorMessage;
        boolean sendToErrorRow;
        Object[] outputRowData;
        block54: {
            Comparable<Date> partitioningValueData;
            Object[] insertRowData;
            if (r == null) {
                if (this.isDetailed()) {
                    this.logDetailed("Last line inserted: stop");
                }
                return null;
            }
            PreparedStatement insertStatement = null;
            outputRowData = r;
            Object tableName = null;
            sendToErrorRow = false;
            errorMessage = null;
            rowIsSafe = false;
            updateCounts = null;
            exceptionsList = null;
            batchProblem = false;
            generatedKey = null;
            if (((TableOutputMeta)this.meta).isTableNameInField()) {
                if (((TableOutputData)this.data).indexOfTableNameField < 0) {
                    String realTablename = this.resolve(((TableOutputMeta)this.meta).getTableNameField());
                    ((TableOutputData)this.data).indexOfTableNameField = rowMeta.indexOfValue(realTablename);
                    if (((TableOutputData)this.data).indexOfTableNameField < 0) {
                        String message = "Unable to find table name field [" + realTablename + "] in input row";
                        this.logError(message);
                        throw new HopTransformException(message);
                    }
                    if (!((TableOutputMeta)this.meta).isTableNameInTable() && !((TableOutputMeta)this.meta).isSpecifyFields()) {
                        ((TableOutputData)this.data).insertRowMeta.removeValueMeta(((TableOutputData)this.data).indexOfTableNameField);
                    }
                }
                tableName = rowMeta.getString(r, ((TableOutputData)this.data).indexOfTableNameField);
                insertRowData = !((TableOutputMeta)this.meta).isTableNameInTable() && !((TableOutputMeta)this.meta).isSpecifyFields() ? RowDataUtil.removeItem((Object[])rowMeta.cloneRow(r), (int)((TableOutputData)this.data).indexOfTableNameField) : r;
            } else if (((TableOutputMeta)this.meta).isPartitioningEnabled() && (((TableOutputMeta)this.meta).isPartitioningDaily() || ((TableOutputMeta)this.meta).isPartitioningMonthly()) && ((TableOutputMeta)this.meta).getPartitioningField() != null && ((TableOutputMeta)this.meta).getPartitioningField().length() > 0) {
                IValueMeta partitioningValue;
                if (((TableOutputData)this.data).indexOfPartitioningField < 0) {
                    ((TableOutputData)this.data).indexOfPartitioningField = rowMeta.indexOfValue(this.resolve(((TableOutputMeta)this.meta).getPartitioningField()));
                    if (((TableOutputData)this.data).indexOfPartitioningField < 0) {
                        throw new HopTransformException("Unable to find field [" + ((TableOutputMeta)this.meta).getPartitioningField() + "] in the input row!");
                    }
                    ((TableOutputData)this.data).dateFormater = Boolean.TRUE.equals(((TableOutputMeta)this.meta).isPartitioningDaily()) ? new SimpleDateFormat("yyyyMMdd") : new SimpleDateFormat("yyyyMM");
                }
                if (!(partitioningValue = rowMeta.getValueMeta(((TableOutputData)this.data).indexOfPartitioningField)).isDate() || r[((TableOutputData)this.data).indexOfPartitioningField] == null) {
                    throw new HopTransformException("Sorry, the partitioning field needs to contain a data value and can't be empty!");
                }
                partitioningValueData = rowMeta.getDate(r, ((TableOutputData)this.data).indexOfPartitioningField);
                tableName = this.resolve(((TableOutputMeta)this.meta).getTableName()) + "_" + ((TableOutputData)this.data).dateFormater.format((Date)partitioningValueData);
                insertRowData = r;
            } else {
                tableName = ((TableOutputData)this.data).tableName;
                insertRowData = r;
            }
            if (((TableOutputMeta)this.meta).isSpecifyFields()) {
                insertRowData = new Object[((TableOutputData)this.data).valuenrs.length];
                for (int idx = 0; idx < ((TableOutputData)this.data).valuenrs.length; ++idx) {
                    insertRowData[idx] = r[((TableOutputData)this.data).valuenrs[idx]];
                }
            }
            if (Utils.isEmpty((CharSequence)tableName)) {
                throw new HopTransformException("The tablename is not defined (empty)");
            }
            insertStatement = ((TableOutputData)this.data).preparedStatements.get(tableName);
            if (insertStatement == null) {
                String sql = ((TableOutputData)this.data).db.getInsertStatement(this.resolve(((TableOutputMeta)this.meta).getSchemaName()), (String)tableName, ((TableOutputData)this.data).insertRowMeta);
                if (this.isDetailed()) {
                    this.logDetailed("Prepared statement : " + sql);
                }
                insertStatement = ((TableOutputData)this.data).db.prepareSql(sql, ((TableOutputMeta)this.meta).isReturningGeneratedKeys());
                ((TableOutputData)this.data).preparedStatements.put((String)tableName, insertStatement);
            }
            try {
                Integer commitCounter;
                if (((TableOutputData)this.data).useSafePoints) {
                    ((TableOutputData)this.data).savepoint = ((TableOutputData)this.data).db.setSavepoint();
                }
                ((TableOutputData)this.data).db.setValues(((TableOutputData)this.data).insertRowMeta, insertRowData, insertStatement);
                ((TableOutputData)this.data).db.insertRow(insertStatement, ((TableOutputData)this.data).batchMode, false);
                if (this.isRowLevel()) {
                    this.logRowlevel("Written row: " + ((TableOutputData)this.data).insertRowMeta.getString(insertRowData));
                }
                if ((commitCounter = ((TableOutputData)this.data).commitCounterMap.get(tableName)) == null) {
                    commitCounter = 1;
                } else {
                    partitioningValueData = commitCounter;
                    commitCounter = commitCounter + 1;
                }
                ((TableOutputData)this.data).commitCounterMap.put((String)tableName, commitCounter);
                if (((TableOutputData)this.data).useSafePoints && ((TableOutputData)this.data).releaseSavepoint) {
                    ((TableOutputData)this.data).db.releaseSavepoint(((TableOutputData)this.data).savepoint);
                }
                if (((TableOutputData)this.data).commitSize > 0 && commitCounter % ((TableOutputData)this.data).commitSize == 0) {
                    if (((TableOutputData)this.data).db.getUseBatchInsert(((TableOutputData)this.data).batchMode)) {
                        try {
                            insertStatement.executeBatch();
                            ((TableOutputData)this.data).db.commit();
                            insertStatement.clearBatch();
                        }
                        catch (SQLException ex) {
                            throw Database.createHopDatabaseBatchException((String)"Error updating batch", (SQLException)ex);
                        }
                        catch (Exception ex) {
                            throw new HopDatabaseException("Unexpected error inserting row", (Throwable)ex);
                        }
                    } else {
                        ((TableOutputData)this.data).db.commit();
                    }
                    ((TableOutputData)this.data).commitCounterMap.put((String)tableName, 0);
                    rowIsSafe = true;
                } else {
                    rowIsSafe = false;
                }
                if (!((TableOutputMeta)this.meta).isReturningGeneratedKeys()) break block54;
                RowMetaAndData extraKeys = ((TableOutputData)this.data).db.getGeneratedKeys(insertStatement);
                if (extraKeys.getRowMeta().size() > 0) {
                    generatedKey = extraKeys.getRowMeta().getInteger(extraKeys.getData(), 0);
                    break block54;
                }
                throw new HopTransformException("No generated keys while \"return generated keys\" is active!");
            }
            catch (HopDatabaseBatchException be) {
                errorMessage = be.toString();
                batchProblem = true;
                sendToErrorRow = true;
                updateCounts = be.getUpdateCounts();
                exceptionsList = be.getExceptionsList();
                if (this.getTransformMeta().isDoingErrorHandling()) {
                    ((TableOutputData)this.data).db.clearBatch(insertStatement);
                    ((TableOutputData)this.data).db.commit(true);
                }
                ((TableOutputData)this.data).db.clearBatch(insertStatement);
                ((TableOutputData)this.data).db.rollback();
                StringBuilder msg = new StringBuilder("Error batch inserting rows into table [" + (String)tableName + "].");
                msg.append(Const.CR);
                msg.append("Errors encountered (first 10):").append(Const.CR);
                for (int x = 0; x < be.getExceptionsList().size() && x < 10; ++x) {
                    Exception exception = (Exception)be.getExceptionsList().get(x);
                    if (exception.getMessage() == null) continue;
                    msg.append(exception.getMessage()).append(Const.CR);
                }
                throw new HopException(msg.toString(), (Throwable)be);
            }
            catch (HopDatabaseException dbe) {
                if (this.getTransformMeta().isDoingErrorHandling()) {
                    if (this.isRowLevel()) {
                        this.logRowlevel("Written row to error handling : " + this.getInputRowMeta().getString(r));
                    }
                    if (((TableOutputData)this.data).useSafePoints) {
                        ((TableOutputData)this.data).db.rollback(((TableOutputData)this.data).savepoint);
                        if (((TableOutputData)this.data).releaseSavepoint) {
                            ((TableOutputData)this.data).db.releaseSavepoint(((TableOutputData)this.data).savepoint);
                        }
                    }
                    sendToErrorRow = true;
                    errorMessage = dbe.toString();
                }
                if (((TableOutputMeta)this.meta).isIgnoreErrors()) {
                    if (((TableOutputData)this.data).warnings < 20) {
                        if (this.isBasic()) {
                            this.logBasic("WARNING: Couldn't insert row into table: " + rowMeta.getString(r) + Const.CR + dbe.getMessage());
                        }
                    } else if (((TableOutputData)this.data).warnings == 20 && this.isBasic()) {
                        this.logBasic("FINAL WARNING (no more then 20 displayed): Couldn't insert row into table: " + rowMeta.getString(r) + Const.CR + dbe.getMessage());
                    }
                    ++((TableOutputData)this.data).warnings;
                }
                this.setErrors(this.getErrors() + 1L);
                ((TableOutputData)this.data).db.rollback();
                throw new HopException("Error inserting row into table [" + (String)tableName + "] with values: " + rowMeta.getString(r), (Throwable)dbe);
            }
        }
        if (generatedKey != null) {
            outputRowData = RowDataUtil.addValueData((Object[])outputRowData, (int)rowMeta.size(), generatedKey);
        }
        if (((TableOutputData)this.data).batchMode) {
            if (sendToErrorRow) {
                if (batchProblem) {
                    ((TableOutputData)this.data).batchBuffer.add(outputRowData);
                    outputRowData = null;
                    this.processBatchException(errorMessage, updateCounts, exceptionsList);
                } else {
                    this.putError(rowMeta, r, 1L, errorMessage, null, "TOP001");
                    outputRowData = null;
                }
            } else {
                ((TableOutputData)this.data).batchBuffer.add(outputRowData);
                outputRowData = null;
                if (rowIsSafe) {
                    for (int i = 0; i < ((TableOutputData)this.data).batchBuffer.size(); ++i) {
                        Object[] row = ((TableOutputData)this.data).batchBuffer.get(i);
                        this.putRow(((TableOutputData)this.data).outputRowMeta, row);
                        this.incrementLinesOutput();
                    }
                    ((TableOutputData)this.data).batchBuffer.clear();
                }
            }
        } else if (sendToErrorRow) {
            this.putError(rowMeta, r, 1L, errorMessage, null, "TOP001");
            outputRowData = null;
        }
        return outputRowData;
    }

    private void processBatchException(String errorMessage, int[] updateCounts, List<Exception> exceptionsList) throws HopException {
        if (updateCounts != null) {
            int errNr = 0;
            for (int i = 0; i < updateCounts.length; ++i) {
                Object[] row = ((TableOutputData)this.data).batchBuffer.get(i);
                if (updateCounts[i] > 0) {
                    this.putRow(((TableOutputData)this.data).outputRowMeta, row);
                    this.incrementLinesOutput();
                    continue;
                }
                String exMessage = errorMessage;
                if (errNr < exceptionsList.size()) {
                    SQLException se = (SQLException)exceptionsList.get(errNr);
                    ++errNr;
                    exMessage = se.toString();
                }
                this.putError(((TableOutputData)this.data).outputRowMeta, row, 1L, exMessage, null, "TOP0002");
            }
        } else {
            for (int i = 0; i < ((TableOutputData)this.data).batchBuffer.size(); ++i) {
                Object[] row = ((TableOutputData)this.data).batchBuffer.get(i);
                this.putError(((TableOutputData)this.data).outputRowMeta, row, 1L, errorMessage, null, "TOP0003");
            }
        }
        ((TableOutputData)this.data).batchBuffer.clear();
    }

    public boolean init() {
        if (super.init()) {
            try {
                ((TableOutputData)this.data).commitSize = Integer.parseInt(this.resolve(((TableOutputMeta)this.meta).getCommitSize()));
                if (Utils.isEmpty((CharSequence)((TableOutputMeta)this.meta).getConnection())) {
                    throw new HopException(BaseMessages.getString(PKG, (String)"TableOutput.Init.ConnectionMissing", (String[])new String[0]));
                }
                ((TableOutputData)this.data).databaseMeta = this.getPipelineMeta().findDatabase(((TableOutputMeta)this.meta).getConnection(), this.variables);
                IDatabase dbInterface = ((TableOutputData)this.data).databaseMeta.getIDatabase();
                ((TableOutputData)this.data).useSafePoints = ((TableOutputData)this.data).databaseMeta.getIDatabase().isUseSafePoints() && this.getTransformMeta().isDoingErrorHandling();
                ((TableOutputData)this.data).releaseSavepoint = dbInterface.isReleaseSavepoint();
                boolean bl = ((TableOutputData)this.data).batchMode = ((TableOutputMeta)this.meta).isUseBatchUpdate() && ((TableOutputData)this.data).commitSize > 0 && !((TableOutputMeta)this.meta).isReturningGeneratedKeys() && !((TableOutputData)this.data).useSafePoints;
                if (this.getTransformMeta().isDoingErrorHandling() && !dbInterface.IsSupportsErrorHandlingOnBatchUpdates()) {
                    this.logBasic(BaseMessages.getString(PKG, (String)"TableOutput.Warning.ErrorHandlingIsNotFullySupportedWithBatchProcessing", (String[])new String[0]));
                }
                if (!dbInterface.supportsStandardTableOutput()) {
                    throw new HopException(dbInterface.getUnsupportedTableOutputMessage());
                }
                ((TableOutputData)this.data).db = new Database((ILoggingObject)this, (IVariables)this, ((TableOutputData)this.data).databaseMeta);
                ((TableOutputData)this.data).db.connect();
                if (this.isBasic()) {
                    this.logBasic("Connected to database [" + this.variables.resolve(((TableOutputMeta)this.meta).getConnection()) + "] (commit=" + ((TableOutputData)this.data).commitSize + ")");
                }
                if (((TableOutputData)this.data).commitSize == 0) {
                    ((TableOutputData)this.data).commitSize = Integer.MAX_VALUE;
                }
                ((TableOutputData)this.data).db.setCommit(((TableOutputData)this.data).commitSize);
                if (!((TableOutputMeta)this.meta).isPartitioningEnabled() && !((TableOutputMeta)this.meta).isTableNameInField()) {
                    ((TableOutputData)this.data).tableName = this.resolve(((TableOutputMeta)this.meta).getTableName());
                }
                return true;
            }
            catch (HopException e) {
                this.logError("An error occurred initializing this transform: " + e.getMessage());
                this.stopAll();
                this.setErrors(1L);
            }
        }
        return false;
    }

    void truncateTable() throws HopDatabaseException {
        if (!(((TableOutputMeta)this.meta).isPartitioningEnabled() || ((TableOutputMeta)this.meta).isTableNameInField() || !((TableOutputMeta)this.meta).isTruncateTable() || this.getCopy() != 0 && Utils.isEmpty((CharSequence)this.getPartitionId()))) {
            ((TableOutputData)this.data).db.truncateTable(this.resolve(((TableOutputMeta)this.meta).getSchemaName()), this.resolve(((TableOutputMeta)this.meta).getTableName()));
        }
    }

    public void dispose() {
        if (((TableOutputData)this.data).db != null) {
            try {
                this.emptyAndCommitBatchBuffers(true);
            }
            finally {
                ((TableOutputData)this.data).db.disconnect();
                ((TableOutputData)this.data).db = null;
                ((TableOutputData)this.data).preparedStatements = null;
                ((TableOutputData)this.data).batchBuffer = null;
                ((TableOutputData)this.data).commitCounterMap = null;
                ((TableOutputData)this.data).outputRowMeta = null;
            }
        }
        super.dispose();
    }

    public void batchComplete() throws HopException {
        this.emptyAndCommitBatchBuffers(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void emptyAndCommitBatchBuffers(boolean dispose) {
        try {
            for (String schemaTable : ((TableOutputData)this.data).preparedStatements.keySet()) {
                Integer batchCounter = ((TableOutputData)this.data).commitCounterMap.get(schemaTable);
                if (batchCounter == null || batchCounter == 0) continue;
                PreparedStatement insertStatement = ((TableOutputData)this.data).preparedStatements.get(schemaTable);
                ((TableOutputData)this.data).db.emptyAndCommit(insertStatement, ((TableOutputData)this.data).batchMode, batchCounter.intValue(), dispose);
                ((TableOutputData)this.data).commitCounterMap.put(schemaTable, 0);
            }
            for (int i = 0; i < ((TableOutputData)this.data).batchBuffer.size(); ++i) {
                Object[] row = ((TableOutputData)this.data).batchBuffer.get(i);
                this.putRow(((TableOutputData)this.data).outputRowMeta, row);
                this.incrementLinesOutput();
            }
            ((TableOutputData)this.data).batchBuffer.clear();
        }
        catch (HopDatabaseBatchException be) {
            if (this.getTransformMeta().isDoingErrorHandling()) {
                try {
                    this.processBatchException(be.toString(), be.getUpdateCounts(), be.getExceptionsList());
                }
                catch (HopException e) {
                    this.logError("Unexpected error processing batch error", e);
                    this.setErrors(1L);
                    this.stopAll();
                }
            } else {
                this.logError("Unexpected batch update error committing the database connection.", be);
                this.setErrors(1L);
                this.stopAll();
            }
        }
        catch (Exception dbe) {
            this.logError("Unexpected error committing the database connection.", dbe);
            this.logError(Const.getStackTracker((Throwable)dbe));
            this.setErrors(1L);
            this.stopAll();
        }
        finally {
            this.setOutputDone();
            if (this.getErrors() > 0L) {
                try {
                    ((TableOutputData)this.data).db.rollback();
                }
                catch (HopDatabaseException e) {
                    this.logError("Unexpected error rolling back the database connection.", e);
                }
            }
        }
    }
}

